/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;
import java.util.Vector;

public class RISolver {
    public MatchingMachine mama;
    public RIGraph rgraph;
    public RIGraph qgraph;
    public int numMatches;
    private boolean injective;
    private Vector<Integer>[] symmCond;

    public RISolver(MatchingMachine mama, RIGraph rgraph, RIGraph qgraph, boolean injective, Vector<Integer>[] symmCond) {
        this.mama = mama;
        this.rgraph = rgraph;
        this.qgraph = qgraph;
        this.injective = injective;
        this.symmCond = symmCond;
        this.numMatches = 0;
    }

    public void solve() {
        int ii;
        int nofTargetNodes = this.rgraph.getNumNodes();
        int nof_sn = this.mama.nof_sn;
        int[] edges_sizes = this.mama.edges_sizes;
        MaMaEdge[][] edges = this.mama.edges;
        int[] map_node_to_state = this.mama.map_node_to_state;
        int[] map_state_to_node = this.mama.map_state_to_node;
        int[] parent_state = this.mama.parent_state;
        MamaParentType[] parent_type = this.mama.parent_type;
        Vector<Integer> listAllRef = new Vector<Integer>();
        for (ii = 0; ii < nofTargetNodes; ++ii) {
            listAllRef.add(ii);
        }
        Vector[] candidates = new Vector[nof_sn];
        int[] candidatesIT = new int[nof_sn];
        int[] candidatesSize = new int[nof_sn];
        int[] solution = new int[nof_sn];
        for (ii = 0; ii < nof_sn; ++ii) {
            solution[ii] = -1;
        }
        HashSet[] cmatched = new HashSet[nof_sn];
        for (ii = 0; ii < cmatched.length; ++ii) {
            cmatched[ii] = new HashSet();
        }
        Vector<Integer>[] queryOutAdjLists = this.qgraph.getSetsOutAdiacs();
        Vector<Integer>[] queryInAdjLists = this.qgraph.getSetsInAdiacs();
        Vector<Integer>[] targetOutAdjLists = this.rgraph.getSetsOutAdiacs();
        Vector<Integer>[] targetInAdjLists = this.rgraph.getSetsInAdiacs();
        int[] queryColors = this.qgraph.getColors();
        int[] freqColsQuery = new int[this.qgraph.getNumColors() + 1];
        for (ii = 0; ii < queryColors.length; ++ii) {
            int n = queryColors[ii];
            freqColsQuery[n] = freqColsQuery[n] + 1;
        }
        int[] targetColors = this.rgraph.getColors();
        boolean[] matched = new boolean[nofTargetNodes];
        candidates[0] = listAllRef;
        candidatesSize[0] = nofTargetNodes;
        candidatesIT[0] = -1;
        int psi = -1;
        int si = 0;
        int ci = -1;
        while (si != -1) {
            if (psi >= si) {
                matched[solution[si]] = false;
                if (!this.injective) {
                    int n = targetColors[solution[si]];
                    freqColsQuery[n] = freqColsQuery[n] + 1;
                }
            }
            ci = -1;
            int n = si;
            candidatesIT[n] = candidatesIT[n] + 1;
            while (candidatesIT[si] < candidatesSize[si]) {
                solution[si] = ci = ((Integer)candidates[si].get(candidatesIT[si])).intValue();
                if (!matched[ci] && !cmatched[si].contains(ci) && this.nodeCheck(si, ci, freqColsQuery) && this.condCheck(si, solution) && this.edgesCheck(si, ci, solution, matched)) break;
                ci = -1;
                int n2 = si;
                candidatesIT[n2] = candidatesIT[n2] + 1;
            }
            if (ci == -1) {
                psi = si;
                cmatched[si].clear();
                --si;
                continue;
            }
            cmatched[si].add(ci);
            if (!this.injective) {
                int n3 = targetColors[ci];
                freqColsQuery[n3] = freqColsQuery[n3] - 1;
            }
            if (si == nof_sn - 1) {
                ++this.numMatches;
                psi = si;
                continue;
            }
            matched[solution[si]] = true;
            int sip1 = si + 1;
            if (parent_type[sip1] == MamaParentType.PARENTTYPE_NULL) {
                candidates[sip1] = listAllRef;
                candidatesSize[sip1] = nofTargetNodes;
            } else if (parent_type[sip1] == MamaParentType.PARENTTYPE_IN) {
                candidates[sip1] = targetInAdjLists[solution[parent_state[sip1]]];
                candidatesSize[sip1] = targetInAdjLists[solution[parent_state[sip1]]].size();
            } else {
                candidates[sip1] = targetOutAdjLists[solution[parent_state[sip1]]];
                candidatesSize[sip1] = targetOutAdjLists[solution[parent_state[sip1]]].size();
            }
            candidatesIT[si + 1] = -1;
            psi = si++;
        }
    }

    public boolean condCheck(int si, int[] solution) {
        boolean condCheck = true;
        Vector<Integer> condNode = this.symmCond[this.mama.map_state_to_node[si]];
        int ii = 0;
        for (ii = 0; ii < condNode.size(); ++ii) {
            int targetNode = solution[this.mama.map_node_to_state[condNode.get(ii)]];
            int colTarget1 = this.rgraph.getColors()[solution[si]];
            int colTarget2 = this.rgraph.getColors()[targetNode];
            if (this.injective) {
                if (colTarget1 != colTarget2 || solution[si] >= targetNode) continue;
                condCheck = false;
                break;
            }
            if (solution[si] >= targetNode) continue;
            condCheck = false;
            break;
        }
        return condCheck;
    }

    public boolean nodeCheck(int si, int ci, int[] freqColsQuery) {
        boolean nodeCheck = false;
        if ((this.injective && this.rgraph.colors[ci] == this.qgraph.colors[this.mama.map_state_to_node[si]] || !this.injective && freqColsQuery[this.rgraph.colors[ci]] > 0) && this.rgraph.outAdiacs[ci].size() >= this.qgraph.outAdiacs[this.mama.map_state_to_node[si]].size() && this.rgraph.inAdiacs[ci].size() >= this.qgraph.inAdiacs[this.mama.map_state_to_node[si]].size()) {
            nodeCheck = true;
        }
        return nodeCheck;
    }

    public boolean edgesCheck(int si, int ci, int[] solution, boolean[] matched) {
        int ii = 0;
        for (int me = 0; me < this.mama.edges_sizes[si]; ++me) {
            int source = solution[this.mama.edges[si][me].source];
            int target = solution[this.mama.edges[si][me].target];
            for (ii = 0; ii < this.rgraph.outAdiacs[source].size() && this.rgraph.outAdiacs[source].get(ii) != target; ++ii) {
            }
            if (ii < this.rgraph.outAdiacs[source].size()) continue;
            return false;
        }
        return true;
    }
}

