/*
 * Decompiled with CFR 0.152.
 */
import gnu.trove.map.hash.TCustomHashMap;
import java.awt.Color;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYTitleAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;

public class PlotManager {
    private String plotTitle;
    private String plotSubtitle;
    private String netName;

    public PlotManager(String netFile, int motifSize, boolean induced, boolean injective, boolean dependent) {
        String[] split = netFile.split("[\\\\|/]");
        String[] split2 = split[split.length - 1].split("\\.");
        this.netName = split2[0];
        this.plotTitle = "Precision-Recall plot for " + this.netName;
        this.plotSubtitle = "";
        this.plotSubtitle = induced ? this.plotSubtitle + "Induced " : this.plotSubtitle + "Non-induced ";
        this.plotSubtitle = injective ? this.plotSubtitle + "injective " : this.plotSubtitle + "multiset ";
        this.plotSubtitle = this.plotSubtitle + "motifs of size " + motifSize + " with color-topology ";
        this.plotSubtitle = dependent ? this.plotSubtitle + "dependence" : this.plotSubtitle + "independence";
    }

    public JFreeChart createPRPlot(TCustomHashMap<int[], double[]>[] mapMotifsInfo) {
        Vector<String> precRecValues = PlotManager.getPrecRecallValues(mapMotifsInfo);
        XYDataset dataset = PlotManager.createDataset(this.netName, precRecValues);
        JFreeChart chart = PlotManager.createChart(this.plotTitle, this.plotSubtitle, dataset);
        return chart;
    }

    private static XYDataset createDataset(String netName, Vector<String> precRecValues) {
        XYSeries series = new XYSeries((Comparable)((Object)netName));
        int i = 0;
        for (i = 0; i < precRecValues.size(); ++i) {
            String[] split = precRecValues.get(i).split("-");
            double recall = Double.parseDouble(split[0]);
            double prec = Double.parseDouble(split[1]);
            series.add(recall, prec);
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    private static JFreeChart createChart(String titleText, String subtitleText, XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart(titleText, "Recall (%)", "Precision (%)", dataset, PlotOrientation.VERTICAL, false, true, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint(Color.white);
        NumberAxis domain = (NumberAxis)plot.getDomainAxis();
        domain.setRange(0.0, 102.0);
        domain.setTickUnit(new NumberTickUnit(5.0));
        NumberAxis range = (NumberAxis)plot.getRangeAxis();
        range.setRange(0.0, 102.0);
        range.setTickUnit(new NumberTickUnit(10.0));
        LegendTitle lt = new LegendTitle(plot);
        lt.setFrame(new BlockBorder(Color.black));
        lt.setPosition(RectangleEdge.BOTTOM);
        XYTitleAnnotation ta = new XYTitleAnnotation(0.02, 0.02, lt, RectangleAnchor.BOTTOM_LEFT);
        ta.setMaxWidth(0.2);
        plot.addAnnotation(ta);
        TextTitle subtitle = new TextTitle(subtitleText);
        chart.addSubtitle(subtitle);
        return chart;
    }

    public static Vector<String> getPrecRecallValues(TCustomHashMap<int[], double[]>[] mapMotifsInfo) {
        Vector<Double> pvalsAnal = new Vector<Double>();
        Vector<Double> pvalsSimul = new Vector<Double>();
        int i = 0;
        for (i = 0; i < mapMotifsInfo.length; ++i) {
            for (int[] setCols : mapMotifsInfo[i].keySet()) {
                double[] motifInfo = mapMotifsInfo[i].get(setCols);
                pvalsAnal.add(motifInfo[3]);
                pvalsSimul.add(motifInfo[5]);
            }
        }
        double thresholdPval = 0.05;
        double pvalRef = 0.0;
        String lastValPrecRec = "";
        Vector<String> precRecList = new Vector<String>();
        for (pvalRef = 0.0; pvalRef <= 1.0; pvalRef += 1.0E-4) {
            String valPrecRec;
            double numTruePositives = 0.0;
            double numFalsePositives = 0.0;
            double numFalseNegatives = 0.0;
            for (i = 0; i < pvalsSimul.size(); ++i) {
                double simulPval = (Double)pvalsSimul.get(i);
                double analPval = (Double)pvalsAnal.get(i);
                if (simulPval <= thresholdPval) {
                    if (analPval <= pvalRef) {
                        numTruePositives += 1.0;
                        continue;
                    }
                    numFalseNegatives += 1.0;
                    continue;
                }
                if (!(analPval <= pvalRef)) continue;
                numFalsePositives += 1.0;
            }
            double precision = 1.0;
            double recall = 1.0;
            if (numTruePositives + numFalsePositives > 0.0) {
                precision = numTruePositives / (numTruePositives + numFalsePositives);
            }
            if (numTruePositives + numFalseNegatives > 0.0) {
                recall = numTruePositives / (numTruePositives + numFalseNegatives);
            }
            if ((valPrecRec = (recall *= 100.0) + "-" + (precision *= 100.0)).equals(lastValPrecRec)) continue;
            precRecList.add(valPrecRec);
            lastValPrecRec = valPrecRec;
        }
        return precRecList;
    }
}

