/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class MatchingMachine {
    public int nof_sn;
    public int[] edges_sizes;
    public int[] o_edges_sizes;
    public int[] i_edges_sizes;
    public MaMaEdge[][] edges;
    public int[] map_node_to_state;
    public int[] map_state_to_node;
    public int[] parent_state;
    public MamaParentType[] parent_type;

    public MatchingMachine(RIGraph query) {
        this.nof_sn = query.getNumNodes();
        this.edges_sizes = new int[this.nof_sn];
        this.o_edges_sizes = new int[this.nof_sn];
        this.i_edges_sizes = new int[this.nof_sn];
        this.edges = new MaMaEdge[this.nof_sn][];
        this.map_node_to_state = new int[this.nof_sn];
        this.map_state_to_node = new int[this.nof_sn];
        this.parent_state = new int[this.nof_sn];
        this.parent_type = new MamaParentType[this.nof_sn];
    }

    public void build(RIGraph ssg) {
        int n;
        int si;
        Vector<Integer>[] outAdiacs = ssg.getSetsOutAdiacs();
        Vector<Integer>[] inAdiacs = ssg.getSetsInAdiacs();
        int i = 0;
        int j = 0;
        NodeFlag[] node_flags = new NodeFlag[this.nof_sn];
        int[][] weights = new int[this.nof_sn][3];
        int[] t_parent_node = new int[this.nof_sn];
        MamaParentType[] t_parent_type = new MamaParentType[this.nof_sn];
        for (i = 0; i < this.nof_sn; ++i) {
            node_flags[i] = NodeFlag.NS_UNV;
            weights[i] = new int[3];
            weights[i][0] = 0;
            weights[i][1] = 0;
            weights[i][2] = outAdiacs[i].size() + inAdiacs[i].size();
            t_parent_node[i] = -1;
            t_parent_type[i] = MamaParentType.PARENTTYPE_NULL;
        }
        int nqueueL = 0;
        int nqueueR = 0;
        for (si = 0; si < this.nof_sn; ++si) {
            int nni;
            int ni;
            int maxi;
            if (nqueueL == nqueueR) {
                maxi = -1;
                int maxv = -1;
                for (int nIT = 0; nIT < this.nof_sn; ++nIT) {
                    if (node_flags[nIT] != NodeFlag.NS_UNV || weights[nIT][2] <= maxv) continue;
                    maxv = weights[nIT][2];
                    maxi = nIT;
                }
                this.map_state_to_node[si] = maxi;
                this.map_node_to_state[maxi] = si;
                t_parent_type[maxi] = MamaParentType.PARENTTYPE_NULL;
                t_parent_node[maxi] = -1;
                ++nqueueR;
                n = maxi;
                for (i = 0; i < outAdiacs[n].size(); ++i) {
                    ni = outAdiacs[n].get(i);
                    if (ni == n) continue;
                    int[] nArray = weights[ni];
                    nArray[1] = nArray[1] + 1;
                }
                for (i = 0; i < inAdiacs[n].size(); ++i) {
                    ni = inAdiacs[n].get(i);
                    if (ni == n) continue;
                    int[] nArray = weights[ni];
                    nArray[1] = nArray[1] + 1;
                }
            }
            if (nqueueL != nqueueR - 1) {
                maxi = nqueueL;
                for (int mi = maxi + 1; mi < nqueueR; ++mi) {
                    if (this.wcompare(this.map_state_to_node[mi], this.map_state_to_node[maxi], weights) >= 0) continue;
                    maxi = mi;
                }
                int tmp = this.map_state_to_node[nqueueL];
                this.map_state_to_node[nqueueL] = this.map_state_to_node[maxi];
                this.map_state_to_node[maxi] = tmp;
            }
            n = this.map_state_to_node[si];
            this.map_node_to_state[n] = si;
            ++nqueueL;
            node_flags[n] = NodeFlag.NS_CORE;
            for (i = 0; i < outAdiacs[n].size(); ++i) {
                ni = outAdiacs[n].get(i);
                if (ni == n) continue;
                int[] nArray = weights[ni];
                nArray[0] = nArray[0] + 1;
                int[] nArray2 = weights[ni];
                nArray2[1] = nArray2[1] - 1;
                if (node_flags[ni] != NodeFlag.NS_UNV) continue;
                node_flags[ni] = NodeFlag.NS_CNEIGH;
                t_parent_node[ni] = n;
                t_parent_type[ni] = MamaParentType.PARENTTYPE_OUT;
                this.map_state_to_node[nqueueR] = ni;
                this.map_node_to_state[ni] = nqueueR++;
                boolean nnIT = false;
                for (j = 0; j < outAdiacs[ni].size(); ++j) {
                    nni = outAdiacs[ni].get(j);
                    int[] nArray3 = weights[nni];
                    nArray3[1] = nArray3[1] + 1;
                }
            }
            for (i = 0; i < inAdiacs[n].size(); ++i) {
                ni = inAdiacs[n].get(i);
                if (ni == n) continue;
                int[] nArray = weights[ni];
                nArray[0] = nArray[0] + 1;
                int[] nArray4 = weights[ni];
                nArray4[1] = nArray4[1] - 1;
                if (node_flags[ni] != NodeFlag.NS_UNV) continue;
                node_flags[ni] = NodeFlag.NS_CNEIGH;
                t_parent_node[ni] = n;
                t_parent_type[ni] = MamaParentType.PARENTTYPE_IN;
                this.map_state_to_node[nqueueR] = ni;
                this.map_node_to_state[ni] = nqueueR++;
                for (j = 0; j < inAdiacs[ni].size(); ++j) {
                    nni = inAdiacs[ni].get(j);
                    int[] nArray5 = weights[nni];
                    nArray5[1] = nArray5[1] + 1;
                }
            }
        }
        for (si = 0; si < this.nof_sn; ++si) {
            int idOut;
            n = this.map_state_to_node[si];
            this.parent_state[si] = t_parent_node[n] != -1 ? this.map_node_to_state[t_parent_node[n]] : -1;
            this.parent_type[si] = t_parent_type[n];
            int e_count = 0;
            int o_e_count = 0;
            for (i = 0; i < outAdiacs[n].size(); ++i) {
                idOut = outAdiacs[n].get(i);
                if (this.map_node_to_state[idOut] >= si) continue;
                ++e_count;
                ++o_e_count;
            }
            int i_e_count = 0;
            for (i = 0; i < inAdiacs[n].size(); ++i) {
                int idIn = inAdiacs[n].get(i);
                if (this.map_node_to_state[idIn] >= si) continue;
                ++e_count;
                ++i_e_count;
            }
            this.edges_sizes[si] = e_count;
            this.o_edges_sizes[si] = o_e_count;
            this.i_edges_sizes[si] = i_e_count;
            this.edges[si] = new MaMaEdge[e_count];
            e_count = 0;
            for (i = 0; i < outAdiacs[n].size(); ++i) {
                idOut = outAdiacs[n].get(i);
                if (this.map_node_to_state[idOut] >= si) continue;
                this.edges[si][e_count] = new MaMaEdge(this.map_node_to_state[n], this.map_node_to_state[idOut]);
                ++e_count;
            }
            for (j = 0; j < si; ++j) {
                int sn = this.map_state_to_node[j];
                for (i = 0; i < outAdiacs[sn].size(); ++i) {
                    int idOut2 = outAdiacs[sn].get(i);
                    if (idOut2 != n) continue;
                    this.edges[si][e_count] = new MaMaEdge(j, si);
                    ++e_count;
                }
            }
        }
    }

    private int wcompare(int i, int j, int[][] weights) {
        for (int w = 0; w < 3; ++w) {
            if (weights[i][w] == weights[j][w]) continue;
            return weights[j][w] - weights[i][w];
        }
        return i - j;
    }

    public static enum NodeFlag {
        NS_CORE,
        NS_CNEIGH,
        NS_UNV;

    }
}

