/*
 * Decompiled with CFR 0.152.
 */
import gnu.trove.set.hash.TCustomHashSet;
import java.util.Vector;

public class GraphUtility {
    public static int[] reorderNodes(int[] colors) {
        int[] labelPerm = new int[colors.length];
        int i = 0;
        for (i = 0; i < labelPerm.length; ++i) {
            labelPerm[i] = i;
        }
        GraphUtility.quickSortPerm(colors, labelPerm, 0, colors.length - 1);
        int[] newColors = new int[colors.length];
        for (i = 0; i < newColors.length; ++i) {
            newColors[i] = colors[labelPerm[i]];
        }
        for (i = 0; i < colors.length; ++i) {
            colors[i] = newColors[i];
        }
        int[] nodeMap = new int[colors.length];
        for (i = 0; i < nodeMap.length; ++i) {
            nodeMap[labelPerm[i]] = i;
        }
        return nodeMap;
    }

    private static void quickSortPerm(int[] array, int[] arrayIds, int lowerIndex, int higherIndex) {
        int i = lowerIndex;
        int j = higherIndex;
        int pivot = array[arrayIds[lowerIndex + (higherIndex - lowerIndex) / 2]];
        while (i <= j) {
            while (array[arrayIds[i]] < pivot) {
                ++i;
            }
            while (array[arrayIds[j]] > pivot) {
                --j;
            }
            if (i > j) continue;
            int temp = arrayIds[i];
            arrayIds[i] = arrayIds[j];
            arrayIds[j] = temp;
            ++i;
            --j;
        }
        if (lowerIndex < j) {
            GraphUtility.quickSortPerm(array, arrayIds, lowerIndex, j);
        }
        if (i < higherIndex) {
            GraphUtility.quickSortPerm(array, arrayIds, i, higherIndex);
        }
    }

    public static boolean[][] getCanonAdj(boolean[][] adjMatrix) {
        int numNodes = adjMatrix.length;
        int[] outDegrees = new int[numNodes];
        int[] inDegrees = new int[numNodes];
        int i = 0;
        int j = 0;
        int k = 0;
        Vector<Integer> setAdiacs = new Vector<Integer>();
        for (i = 0; i < numNodes; ++i) {
            setAdiacs.add(i);
            for (j = 0; j < numNodes; ++j) {
                if (!adjMatrix[i][j]) continue;
                int n = i;
                outDegrees[n] = outDegrees[n] + 1;
                int n2 = j;
                inDegrees[n2] = inDegrees[n2] + 1;
            }
        }
        int[] canonMap = new int[numNodes];
        boolean[] used = new boolean[numNodes];
        for (i = 0; i < numNodes; ++i) {
            int maxDegOut = -1;
            int maxDegIn = -1;
            int maxId = 0;
            for (j = 0; j < setAdiacs.size(); ++j) {
                int idNode = (Integer)setAdiacs.get(j);
                if (outDegrees[idNode] > maxDegOut) {
                    maxDegOut = outDegrees[idNode];
                    maxDegIn = inDegrees[idNode];
                    maxId = idNode;
                    continue;
                }
                if (outDegrees[idNode] != maxDegOut || inDegrees[idNode] <= maxDegIn) continue;
                maxDegIn = inDegrees[idNode];
                maxId = idNode;
            }
            canonMap[i] = maxId;
            used[maxId] = true;
            setAdiacs.clear();
            for (j = 0; j <= i; ++j) {
                int idSource = canonMap[j];
                for (k = 0; k < numNodes; ++k) {
                    if (!adjMatrix[idSource][k] || used[k] || setAdiacs.contains(k)) continue;
                    setAdiacs.add(k);
                }
            }
            if (!setAdiacs.isEmpty()) continue;
            for (j = 0; j < numNodes; ++j) {
                if (used[j]) continue;
                setAdiacs.add(j);
            }
        }
        boolean[][] finalAdjMatrix = new boolean[numNodes][numNodes];
        for (i = 0; i < numNodes; ++i) {
            for (j = 0; j < numNodes; ++j) {
                finalAdjMatrix[i][j] = adjMatrix[canonMap[i]][canonMap[j]];
            }
        }
        return finalAdjMatrix;
    }

    public static Vector<int[]> getSymmCondGTrie(boolean[][] adjMat) {
        int i = 0;
        int j = 0;
        int k = 0;
        Vector<int[]> listCond = new Vector<int[]>();
        Vector<int[]> vv = GraphUtility.findAutomorphisms(adjMat);
        int vvsize = vv.size();
        boolean[] broken = new boolean[vvsize];
        int size = adjMat.length;
        for (i = 0; i < size; ++i) {
            for (j = 0; j < vvsize && (broken[j] || vv.get(j)[i] == i); ++j) {
            }
            if (j < vvsize) {
                block2: for (k = i + 1; k < size; ++k) {
                    for (j = 0; j < vvsize; ++j) {
                        if (broken[j] || vv.get(j)[i] != k) continue;
                        int[] p = new int[]{i, k};
                        listCond.add(p);
                        continue block2;
                    }
                }
            }
            for (j = 0; j < vvsize; ++j) {
                if (vv.get(j)[i] == i) continue;
                broken[j] = true;
            }
        }
        return listCond;
    }

    public static Vector<Integer>[] getSymmetryConditions(boolean[][] adjMat, Vector<int[]> vv) {
        int i = 0;
        int j = 0;
        int k = 0;
        int size = adjMat.length;
        Vector[] listCond = new Vector[size];
        for (i = 0; i < listCond.length; ++i) {
            listCond[i] = new Vector();
        }
        int vvsize = vv.size();
        boolean[] broken = new boolean[vvsize];
        for (i = 0; i < size; ++i) {
            for (j = 0; j < vvsize && (broken[j] || vv.get(j)[i] == i); ++j) {
            }
            if (j < vvsize) {
                block3: for (k = i + 1; k < size; ++k) {
                    for (j = 0; j < vvsize; ++j) {
                        if (broken[j] || vv.get(j)[i] != k) continue;
                        int[] p = new int[2];
                        listCond[k].add(i);
                        continue block3;
                    }
                }
            }
            for (j = 0; j < vvsize; ++j) {
                if (vv.get(j)[i] == i) continue;
                broken[j] = true;
            }
        }
        return listCond;
    }

    public static Vector<int[]> findAutomorphisms(boolean[][] adjMat) {
        int i = 0;
        int j = 0;
        int k = 0;
        int g = 0;
        int[] fDir = new int[adjMat.length];
        int[] fRev = new int[adjMat.length];
        for (i = 0; i < fDir.length; ++i) {
            fDir[i] = -1;
            fRev[i] = -1;
        }
        int[][] sequence = new int[adjMat.length][adjMat.length];
        for (i = 0; i < adjMat.length; ++i) {
            for (j = 0; j < adjMat.length; ++j) {
                if (adjMat[i][j] || adjMat[j][i]) {
                    int numNeighs = 0;
                    for (k = 0; k < adjMat.length; ++k) {
                        if (adjMat[j][k]) {
                            ++numNeighs;
                        }
                        if (!adjMat[k][j] || adjMat[j][k]) continue;
                        ++numNeighs;
                    }
                    sequence[i][j] = numNeighs;
                    continue;
                }
                sequence[i][j] = 0;
            }
        }
        for (i = 0; i < adjMat.length; ++i) {
            GraphUtility.insertionSortDesc(sequence[i]);
        }
        boolean[] support = new boolean[adjMat.length * adjMat.length];
        for (i = 0; i < adjMat.length; ++i) {
            for (j = 0; j < adjMat.length; ++j) {
                for (k = 0; k < adjMat.length && sequence[i][k] == sequence[j][k]; ++k) {
                }
                support[i * adjMat.length + j] = k >= adjMat.length;
            }
        }
        Vector<int[]> vv = new Vector<int[]>();
        for (g = 0; g < adjMat.length; ++g) {
            if (!support[g * adjMat.length]) continue;
            fDir[0] = g;
            fRev[g] = 0;
            int pos = 1;
            GraphUtility.isomorphicExtensions(fDir, fRev, adjMat, vv, support, pos);
            fRev[fDir[0]] = -1;
            fDir[0] = -1;
        }
        return vv;
    }

    public static void isomorphicExtensions(int[] fDir, int[] fRev, boolean[][] adjMat, Vector<int[]> vv, boolean[] support, int pos) {
        int i = 0;
        int j = 0;
        boolean k = false;
        int ncand = 0;
        int num = 0;
        int[] cand = new int[adjMat.length];
        for (i = 0; i < cand.length; ++i) {
            cand[i] = -1;
        }
        if (pos == adjMat.length) {
            int[] vTemp = new int[adjMat.length];
            for (i = 0; i < fDir.length; ++i) {
                vTemp[i] = fDir[i];
            }
            vv.add(vTemp);
        } else {
            int n = 0;
            int m = 0;
            boolean flag = false;
            int[] count = new int[adjMat.length];
            ncand = 0;
            for (i = 0; i < adjMat.length; ++i) {
                count[i] = 0;
            }
            for (i = 0; i < adjMat.length; ++i) {
                if (fDir[i] == -1) continue;
                Vector<Integer> vNei = new Vector<Integer>();
                for (j = 0; j < adjMat.length; ++j) {
                    if (adjMat[i][j]) {
                        vNei.add(j);
                    }
                    if (!adjMat[j][i] || adjMat[i][j]) continue;
                    vNei.add(j);
                }
                num = vNei.size();
                for (j = 0; j < num; ++j) {
                    int neigh = (Integer)vNei.get(j);
                    if (fDir[neigh] != -1) continue;
                    if (count[neigh] == 0) {
                        cand[ncand++] = neigh;
                    }
                    int n2 = neigh;
                    count[n2] = count[n2] + 1;
                }
            }
            m = 0;
            for (i = 1; i < ncand; ++i) {
                if (count[i] <= count[m]) continue;
                m = i;
            }
            m = cand[m];
            ncand = 0;
            boolean[] already = new boolean[adjMat.length];
            for (i = 0; i < adjMat.length; ++i) {
                if (fDir[i] == -1) continue;
                Vector<Integer> vNei = new Vector<Integer>();
                for (j = 0; j < adjMat.length; ++j) {
                    if (adjMat[fDir[i]][j]) {
                        vNei.add(j);
                    }
                    if (!adjMat[j][fDir[i]] || adjMat[fDir[i]][j]) continue;
                    vNei.add(j);
                }
                num = vNei.size();
                for (j = 0; j < num; ++j) {
                    int neigh = (Integer)vNei.get(j);
                    if (already[neigh] || fRev[neigh] != -1 || !support[m * adjMat.length + neigh]) continue;
                    cand[ncand++] = neigh;
                    already[neigh] = true;
                }
            }
            for (i = 0; i < ncand; ++i) {
                n = cand[i];
                flag = false;
                for (j = 0; j < adjMat.length; ++j) {
                    if (fDir[j] == -1) continue;
                    if (adjMat[m][j] != adjMat[n][fDir[j]]) {
                        flag = true;
                        break;
                    }
                    if (adjMat[j][m] == adjMat[fDir[j]][n]) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                fDir[m] = n;
                fRev[n] = m;
                GraphUtility.isomorphicExtensions(fDir, fRev, adjMat, vv, support, ++pos);
                --pos;
                fRev[fDir[m]] = -1;
                fDir[m] = -1;
            }
        }
    }

    public static void insertionSortDesc(int[] a) {
        int i = 0;
        int j = 0;
        for (i = 1; i < a.length; ++i) {
            int value = a[i];
            for (j = i - 1; j >= 0 && a[j] < value; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = value;
        }
    }

    public static boolean[][] getAdjMatrix(String str) {
        int sizeMotif = (int)Math.sqrt(str.length());
        boolean[][] adjMatrix = new boolean[sizeMotif][sizeMotif];
        int i = 0;
        for (i = 0; i < str.length(); ++i) {
            adjMatrix[i / sizeMotif][i % sizeMotif] = str.charAt(i) == '1';
        }
        return adjMatrix;
    }

    public static String getAdjString(boolean[][] adjMat) {
        String adjString = "";
        int i = 0;
        int j = 0;
        for (i = 0; i < adjMat.length; ++i) {
            for (j = 0; j < adjMat.length; ++j) {
                adjString = adjMat[i][j] ? adjString + "1" : adjString + "0";
            }
        }
        return adjString;
    }

    public static void getSetsColorsTopo(TCustomHashSet<int[]> permutations, int[] setColors, Vector<Integer>[] symmCond) {
        int i = 0;
        int j = 0;
        for (i = 0; i < symmCond.length; ++i) {
            for (j = 0; j < symmCond[i].size() && setColors[i] >= setColors[symmCond[i].get(j)]; ++j) {
            }
            if (j < symmCond[i].size()) break;
        }
        if (i == symmCond.length) {
            permutations.add(setColors);
        }
        int[] currentPerm = new int[setColors.length];
        for (i = 0; i < currentPerm.length; ++i) {
            currentPerm[i] = i;
        }
        while (GraphUtility.nextPermutation(currentPerm)) {
            int[] newSetColors = new int[setColors.length];
            for (i = 0; i < currentPerm.length; ++i) {
                newSetColors[currentPerm[i]] = setColors[i];
            }
            for (i = 0; i < symmCond.length; ++i) {
                for (j = 0; j < symmCond[i].size() && newSetColors[i] >= newSetColors[symmCond[i].get(j)]; ++j) {
                }
                if (j < symmCond[i].size()) break;
            }
            if (i != symmCond.length) continue;
            permutations.add(newSetColors);
        }
    }

    public static boolean nextPermutation(int[] p) {
        for (int a = p.length - 2; a >= 0; --a) {
            if (p[a] >= p[a + 1]) continue;
            int b = p.length - 1;
            while (true) {
                if (p[b] > p[a]) {
                    int t = p[a];
                    p[a] = p[b];
                    p[b] = t;
                    ++a;
                    for (b = p.length - 1; a < b; ++a, --b) {
                        t = p[a];
                        p[a] = p[b];
                        p[b] = t;
                    }
                    return true;
                }
                --b;
            }
        }
        return false;
    }

    public static int[] selectMinimumAuto(Vector<int[]> autos, int[] colors) {
        int i = 0;
        int j = 0;
        int[] bestAuto = new int[colors.length];
        for (i = 0; i < bestAuto.length; ++i) {
            bestAuto[i] = autos.get(0)[i];
        }
        for (i = 1; i < autos.size(); ++i) {
            int[] auto = autos.get(i);
            boolean minusThan = false;
            for (j = 0; j < auto.length; ++j) {
                if (colors[auto[j]] < colors[bestAuto[j]]) {
                    minusThan = true;
                    break;
                }
                if (colors[auto[j]] > colors[bestAuto[j]]) break;
            }
            if (!minusThan) continue;
            for (j = 0; j < auto.length; ++j) {
                bestAuto[j] = auto[j];
            }
        }
        return bestAuto;
    }
}

