/*
 * Decompiled with CFR 0.152.
 */
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.custom_hash.TObjectLongCustomHashMap;
import gnu.trove.map.hash.TCustomHashMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;

public class GTrie {
    private GTrieNode root = new GTrieNode(false);
    private Graph net;
    private TIntArrayList[] fastnei;
    private int[] colors;
    private int[] mymap;
    private boolean[] used;
    private boolean[] wildcard;
    private int[] freqColsQuery;
    private LinkedList<Integer> labelStack;
    private int glk;
    private boolean injective;

    public GTrie(Vector<boolean[][]> setTopologies) {
        for (int i = 0; i < setTopologies.size(); ++i) {
            boolean[][] adjMotif = setTopologies.get(i);
            Vector<int[]> symmCond = GraphUtility.getSymmCondGTrie(adjMotif);
            this.insertGraphCond(adjMotif, symmCond);
        }
        this.cleanConditions();
    }

    public GTrie(TCustomHashMap<boolean[][], Integer> mapTopoPositions) {
        for (boolean[][] adjMotif : mapTopoPositions.keySet()) {
            Vector<int[]> symmCond = GraphUtility.getSymmCondGTrie(adjMotif);
            this.insertGraphCond(adjMotif, symmCond);
        }
        this.cleanConditions();
    }

    public void insertGraphCond(boolean[][] adjMat, Vector<int[]> cond) {
        this.insertGraphCond(this.root, adjMat, 0, cond);
    }

    public void insertGraphCond(GTrieNode currNode, boolean[][] adjMat, int level, Vector<int[]> cond) {
        if (level == adjMat.length) {
            currNode.setIsGraph(true);
        } else {
            Vector<GTrieNode> children = currNode.getChildren();
            int i = 0;
            int j = 0;
            GTrieNode gt = null;
            for (i = 0; i < children.size(); ++i) {
                gt = children.get(i);
                boolean[] outRef = gt.getOutNeighbors();
                boolean[] inRef = gt.getInNeighbors();
                for (j = 0; j <= level && adjMat[level][j] == outRef[j] && adjMat[j][level] == inRef[j]; ++j) {
                }
                if (j > level) break;
            }
            if (i == children.size()) {
                boolean[] newOut = new boolean[level + 1];
                boolean[] newIn = new boolean[level + 1];
                for (i = 0; i < newOut.length; ++i) {
                    newOut[i] = adjMat[level][i];
                    newIn[i] = adjMat[i][level];
                }
                gt = new GTrieNode(newIn, newOut, false);
                currNode.insertChild(gt);
            }
            this.insertConditionsFiltered(gt, cond, level + 1);
            this.insertGraphCond(gt, adjMat, level + 1, cond);
        }
    }

    public void insertConditionsFiltered(GTrieNode gt, Vector<int[]> conditions, int level) {
        Object cond;
        if (gt.getCondOk()) {
            return;
        }
        Vector<int[]> aux = new Vector<int[]>();
        Vector<Integer> aux_this_node = new Vector<Integer>();
        int j = 0;
        int k = 0;
        int i = 0;
        int m = 0;
        for (j = 0; j < conditions.size(); ++j) {
            int[] cond1 = conditions.get(j);
            block1: for (k = 0; k < conditions.size(); ++k) {
                int[] cond2 = conditions.get(k);
                if (cond1[1] != cond2[0]) continue;
                for (i = 0; i < conditions.size(); ++i) {
                    int[] condRef = conditions.get(i);
                    if (condRef[0] != cond1[0] || condRef[1] != cond2[1]) continue;
                    conditions.removeElementAt(i);
                    --k;
                    continue block1;
                }
            }
        }
        for (j = 0; j < conditions.size(); ++j) {
            cond = conditions.get(j);
            if (cond[0] <= level - 1 && cond[1] <= level - 1) {
                aux.add((int[])cond);
            }
            if (cond[1] != level - 1) continue;
            aux_this_node.add((int)cond[0]);
        }
        if (!gt.getCondOk()) {
            if (aux.size() == 0) {
                gt.setCondOk(true);
                gt.clearConditions();
            } else {
                cond = gt.getSymmCond();
                boolean is_contained = false;
                for (m = 0; m < cond.size(); ++m) {
                    Vector mCond = (Vector)cond.get(m);
                    if (this.isPairsetIncluded(mCond, aux)) {
                        is_contained = true;
                        break;
                    }
                    if (!this.isPairsetIncluded(aux, mCond)) continue;
                    cond.removeElementAt(m);
                    --m;
                }
                if (!is_contained) {
                    cond.add(aux);
                }
            }
        }
    }

    private boolean isPairsetIncluded(Vector<int[]> a, Vector<int[]> b) {
        int i = 0;
        int j = 0;
        while (i < a.size() && j < b.size()) {
            int[] bCond;
            int[] aCond = a.get(i);
            if (aCond[0] == (bCond = b.get(j))[0] && aCond[1] == bCond[1]) {
                ++i;
                ++j;
                continue;
            }
            ++j;
        }
        return i == a.size();
    }

    public void cleanConditions() {
        this.cleanConditions(this.root);
    }

    public void cleanConditions(GTrieNode currNode) {
        int i = 0;
        int j = 0;
        int k = 0;
        Vector<Vector<int[]>> cond = currNode.getSymmCond();
        if (cond.size() > 0) {
            for (j = 0; j < cond.get(0).size(); ++j) {
                int[] c = cond.get(0).get(j);
                for (i = 0; i < cond.size(); ++i) {
                    int[] refC;
                    Vector<int[]> refCond = cond.get(i);
                    for (k = 0; k < refCond.size() && ((refC = refCond.get(k))[0] != c[0] || refC[1] != c[1]); ++k) {
                    }
                    if (k == refCond.size()) break;
                }
                if (i != cond.size()) continue;
                Vector<GTrieNode> children = currNode.getChildren();
                for (i = 0; i < children.size(); ++i) {
                    this.cleanCondition(children.get(i), c[0], c[1]);
                }
            }
        }
        Vector<GTrieNode> children = currNode.getChildren();
        for (i = 0; i < children.size(); ++i) {
            this.cleanConditions(children.get(i));
        }
    }

    public void cleanCondition(GTrieNode currNode, int a, int b) {
        int i = 0;
        int j = 0;
        Vector<Vector<int[]>> cond = currNode.getSymmCond();
        if (cond.size() > 0) {
            for (i = 0; i < cond.size(); ++i) {
                Vector<int[]> condRef = cond.get(i);
                for (j = 0; j < condRef.size(); ++j) {
                    int[] cRef = condRef.get(j);
                    if (cRef[0] != a || cRef[1] != b) continue;
                    condRef.removeElementAt(j);
                    --j;
                }
                if (condRef.size() != 0) continue;
                cond.removeElementAt(i);
                --i;
                currNode.setCondOk(true);
            }
        }
        Vector<GTrieNode> children = currNode.getChildren();
        for (i = 0; i < children.size(); ++i) {
            this.cleanCondition(children.get(i), a, b);
        }
    }

    public void census(Graph graph, int[] colors, int[] queryCols, boolean directed, int subsize, boolean injective) {
        int i = 0;
        int j = 0;
        int numNodes = graph.getNumNodes();
        this.net = graph;
        this.fastnei = graph.getFastnei();
        this.colors = colors;
        this.injective = injective;
        this.mymap = new int[subsize];
        this.used = new boolean[numNodes];
        this.wildcard = new boolean[numNodes];
        this.freqColsQuery = new int[graph.getNumColors() + 1];
        for (i = 0; i < queryCols.length; ++i) {
            int n = queryCols[i];
            this.freqColsQuery[n] = this.freqColsQuery[n] + 1;
        }
        this.labelStack = new LinkedList();
        this.glk = 1;
        Vector<GTrieNode> children = this.root.getChildren().get(0).getChildren();
        for (i = 0; i < numNodes; ++i) {
            if (this.freqColsQuery[colors[i]] > 0) {
                int n = colors[i];
                this.freqColsQuery[n] = this.freqColsQuery[n] - 1;
                this.wildcard[i] = false;
            } else {
                if (this.freqColsQuery[0] <= 0) continue;
                this.wildcard[i] = true;
                this.freqColsQuery[0] = this.freqColsQuery[0] - 1;
            }
            this.mymap[0] = i;
            this.labelStack.add(colors[i]);
            this.used[i] = true;
            if (directed) {
                for (j = 0; j < children.size(); ++j) {
                    this.goCondDir(children.get(j));
                }
            } else {
                for (j = 0; j < children.size(); ++j) {
                    this.goCondUndir(children.get(j));
                }
            }
            this.used[i] = false;
            if (this.wildcard[i]) {
                this.freqColsQuery[0] = this.freqColsQuery[0] + 1;
            } else {
                int n = colors[i];
                this.freqColsQuery[n] = this.freqColsQuery[n] + 1;
            }
            this.labelStack.removeLast();
        }
    }

    public void goCondUndir(GTrieNode currNode) {
        int i = 0;
        int j = 0;
        int k = 0;
        int glaux = 0;
        int mylim = Integer.MAX_VALUE;
        if (!currNode.getCondOk()) {
            Vector<Vector<int[]>> cond = currNode.getSymmCond();
            boolean flag = true;
            for (j = 0; j < cond.size(); ++j) {
                int[] cArray;
                glaux = -1;
                Vector<int[]> c = cond.get(j);
                for (k = 0; k < c.size() && ((cArray = c.get(k))[1] >= this.glk || this.mymap[cArray[0]] <= this.mymap[cArray[1]]); ++k) {
                    if (cArray[1] != this.glk || this.mymap[cArray[0]] <= glaux) continue;
                    glaux = this.mymap[cArray[0]];
                }
                if (k != c.size()) continue;
                flag = false;
                if (glaux >= mylim) continue;
                mylim = glaux;
            }
            if (flag) {
                return;
            }
        }
        if (mylim == Integer.MAX_VALUE) {
            mylim = 0;
        }
        int ncand = 0;
        int ci = Integer.MAX_VALUE;
        j = Integer.MAX_VALUE;
        Vector<Integer> conn = currNode.getConnNodes();
        for (i = 0; i < conn.size(); ++i) {
            glaux = this.fastnei[this.mymap[conn.get(i)]].size();
            if (glaux >= j) continue;
            ci = this.mymap[conn.get(i)];
            j = glaux;
        }
        glaux = j;
        ncand = ci;
        boolean[] out = currNode.getOutNeighbors();
        ci = glaux - 1;
        while (ci >= 0) {
            i = this.fastnei[ncand].get(j - 1);
            if (!this.used[i]) {
                if (i < mylim) break;
                if (this.freqColsQuery[this.colors[i]] != 0 || this.freqColsQuery[0] != 0) {
                    this.mymap[this.glk] = i;
                    for (k = 0; k < this.glk && out[k] == this.net.isEdge(i, this.mymap[k]); ++k) {
                    }
                    if (k >= this.glk) {
                        this.labelStack.add(this.colors[i]);
                        if (currNode.isLeaf()) {
                            int[] occLabs = new int[this.labelStack.size()];
                            for (k = 0; k < occLabs.length; ++k) {
                                occLabs[k] = this.labelStack.get(k);
                            }
                            if (!this.injective) {
                                Arrays.sort(occLabs);
                            }
                            currNode.incFrequency(occLabs);
                        }
                        this.used[i] = true;
                        if (this.freqColsQuery[this.colors[i]] > 0) {
                            int n = this.colors[i];
                            this.freqColsQuery[n] = this.freqColsQuery[n] - 1;
                            this.wildcard[i] = false;
                        } else {
                            this.wildcard[i] = true;
                            this.freqColsQuery[0] = this.freqColsQuery[0] - 1;
                        }
                        ++this.glk;
                        Vector<GTrieNode> children = currNode.getChildren();
                        for (k = 0; k < children.size(); ++k) {
                            this.goCondUndir(children.get(k));
                        }
                        --this.glk;
                        this.used[i] = false;
                        if (this.wildcard[i]) {
                            this.freqColsQuery[0] = this.freqColsQuery[0] + 1;
                        } else {
                            int n = this.colors[i];
                            this.freqColsQuery[n] = this.freqColsQuery[n] + 1;
                        }
                        this.labelStack.removeLast();
                    }
                }
            }
            --ci;
            --j;
        }
    }

    public void goCondDir(GTrieNode currNode) {
        int i = 0;
        int j = 0;
        int k = 0;
        int glaux = 0;
        int mylim = Integer.MAX_VALUE;
        if (!currNode.getCondOk()) {
            Vector<Vector<int[]>> cond = currNode.getSymmCond();
            boolean flag = true;
            for (j = 0; j < cond.size(); ++j) {
                int[] cArray;
                glaux = -1;
                Vector<int[]> c = cond.get(j);
                for (k = 0; k < c.size() && ((cArray = c.get(k))[1] >= this.glk || this.mymap[cArray[0]] <= this.mymap[cArray[1]]); ++k) {
                    if (cArray[1] != this.glk || this.mymap[cArray[0]] <= glaux) continue;
                    glaux = this.mymap[cArray[0]];
                }
                if (k != c.size()) continue;
                flag = false;
                if (glaux >= mylim) continue;
                mylim = glaux;
            }
            if (flag) {
                return;
            }
        }
        if (mylim == Integer.MAX_VALUE) {
            mylim = 0;
        }
        int ncand = 0;
        int ci = Integer.MAX_VALUE;
        j = Integer.MAX_VALUE;
        Vector<Integer> conn = currNode.getConnNodes();
        for (i = 0; i < conn.size(); ++i) {
            glaux = this.fastnei[this.mymap[conn.get(i)]].size();
            if (glaux >= j) continue;
            ci = this.mymap[conn.get(i)];
            j = glaux;
        }
        glaux = j;
        ncand = ci;
        boolean[] out = currNode.getOutNeighbors();
        boolean[] in = currNode.getInNeighbors();
        ci = glaux - 1;
        while (ci >= 0) {
            i = this.fastnei[ncand].get(j - 1);
            if (!this.used[i]) {
                if (i < mylim) break;
                if (this.freqColsQuery[this.colors[i]] != 0 || this.freqColsQuery[0] != 0) {
                    this.mymap[this.glk] = i;
                    for (k = 0; k < this.glk && in[k] == this.net.isEdge(this.mymap[k], i); ++k) {
                    }
                    if (k >= this.glk) {
                        for (k = 0; k < this.glk && out[k] == this.net.isEdge(i, this.mymap[k]); ++k) {
                        }
                        if (k >= this.glk) {
                            this.labelStack.add(this.colors[i]);
                            if (currNode.isLeaf()) {
                                int[] occLabs = new int[this.labelStack.size()];
                                for (k = 0; k < occLabs.length; ++k) {
                                    occLabs[k] = this.labelStack.get(k);
                                }
                                if (!this.injective) {
                                    Arrays.sort(occLabs);
                                }
                                currNode.incFrequency(occLabs);
                            }
                            this.used[i] = true;
                            if (this.freqColsQuery[this.colors[i]] > 0) {
                                int n = this.colors[i];
                                this.freqColsQuery[n] = this.freqColsQuery[n] - 1;
                                this.wildcard[i] = false;
                            } else {
                                this.wildcard[i] = true;
                                this.freqColsQuery[0] = this.freqColsQuery[0] - 1;
                            }
                            ++this.glk;
                            Vector<GTrieNode> children = currNode.getChildren();
                            for (k = 0; k < children.size(); ++k) {
                                this.goCondDir(children.get(k));
                            }
                            --this.glk;
                            this.used[i] = false;
                            if (this.wildcard[i]) {
                                this.freqColsQuery[0] = this.freqColsQuery[0] + 1;
                            } else {
                                int n = this.colors[i];
                                this.freqColsQuery[n] = this.freqColsQuery[n] + 1;
                            }
                            this.labelStack.removeLast();
                        }
                    }
                }
            }
            --ci;
            --j;
        }
    }

    public String toString() {
        String output = "";
        LinkedList<GTrieNode> queue = new LinkedList<GTrieNode>();
        queue.add(this.root);
        int i = 0;
        int j = 0;
        while (!queue.isEmpty()) {
            Vector<GTrieNode> children;
            GTrieNode curr = (GTrieNode)queue.removeFirst();
            boolean[] outNei = curr.getOutNeighbors();
            boolean[] inNei = curr.getInNeighbors();
            if (outNei != null) {
                for (i = 0; i < outNei.length; ++i) {
                    output = outNei[i] ? output + "1" : output + "0";
                }
                output = output + "-";
                for (i = 0; i < inNei.length; ++i) {
                    output = inNei[i] ? output + "1" : output + "0";
                }
                output = output + " ";
                Vector<Vector<int[]>> symmCond = curr.getSymmCond();
                for (i = 0; i < symmCond.size(); ++i) {
                    Vector<int[]> condList = symmCond.get(i);
                    output = output + "[";
                    for (j = 0; j < condList.size(); ++j) {
                        int[] cond = condList.get(j);
                        output = output + "(" + cond[0] + "," + cond[1] + ")";
                    }
                    output = output + "]";
                }
            } else {
                output = output + "root";
            }
            if ((children = curr.getChildren()).size() > 0) {
                output = output + " --> ";
            }
            for (i = 0; i < children.size(); ++i) {
                GTrieNode child = children.get(i);
                boolean[] outNeiChild = child.getOutNeighbors();
                for (j = 0; j < outNeiChild.length; ++j) {
                    output = outNeiChild[j] ? output + "1" : output + "0";
                }
                output = output + ", ";
                queue.add(child);
            }
            if (children.size() > 0) {
                output = output.substring(0, output.length() - 2);
            }
            output = output + "\n";
        }
        return output;
    }

    public TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> getMotifFrequencies() {
        TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> mapMotifFreqs = new TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>>(new MatrixArrayStrategy());
        this.getMotifFrequencies(this.root, null, mapMotifFreqs);
        return mapMotifFreqs;
    }

    private void getMotifFrequencies(GTrieNode currNode, boolean[][] currAdj, TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> mapMotifFreqs) {
        if (currNode.isLeaf()) {
            mapMotifFreqs.put(currAdj, currNode.getMapFrequencies());
        } else {
            Vector<GTrieNode> children = currNode.getChildren();
            int i = 0;
            int j = 0;
            int k = 0;
            for (i = 0; i < children.size(); ++i) {
                GTrieNode child = children.get(i);
                boolean[] out = child.getOutNeighbors();
                boolean[] in = child.getInNeighbors();
                boolean[][] adjMatrix = new boolean[out.length][out.length];
                if (currAdj != null) {
                    for (j = 0; j < currAdj.length; ++j) {
                        for (k = 0; k < currAdj.length; ++k) {
                            adjMatrix[j][k] = currAdj[j][k];
                        }
                    }
                    for (k = 0; k < out.length; ++k) {
                        adjMatrix[currAdj.length][k] = out[k];
                        adjMatrix[k][currAdj.length] = in[k];
                    }
                } else {
                    adjMatrix[0][0] = out[0];
                }
                this.getMotifFrequencies(child, adjMatrix, mapMotifFreqs);
            }
        }
    }

    public void resetFrequencies() {
        this.resetFrequencies(this.root);
    }

    public void resetFrequencies(GTrieNode currNode) {
        if (currNode.isLeaf()) {
            currNode.resetMapFrequencies();
        } else {
            Vector<GTrieNode> children = currNode.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.resetFrequencies(children.get(i));
            }
        }
    }
}

