/*
 * Decompiled with CFR 0.152.
 */
import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import gnu.trove.map.hash.TCustomHashMap;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;
import org.jfree.chart.JFreeChart;

public class FileManager {
    public Graph readGraph(String graphFile) {
        Graph g = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(graphFile));
            String str = br.readLine();
            boolean directed = false;
            if (str.equals("directed")) {
                directed = true;
            }
            int numNodes = Integer.parseInt(br.readLine());
            int[] colorList = new int[numNodes];
            for (int i = 0; i < numNodes; ++i) {
                int col;
                colorList[i] = col = Integer.parseInt(br.readLine());
            }
            int[] nodeMap = GraphUtility.reorderNodes(colorList);
            g = new Graph(directed, numNodes, colorList);
            while ((str = br.readLine()) != null) {
                String[] split = str.split(" ");
                int source = Integer.parseInt(split[0]);
                int dest = Integer.parseInt(split[1]);
                g.addEdge(nodeMap[source], nodeMap[dest]);
            }
            br.close();
            g.sortFastnei();
            if (directed) {
                g.sortAdjList();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return g;
    }

    public TCustomHashMap<boolean[][], Integer> buildCompleteTopoSet(int motifSize, boolean directed) {
        TCustomHashMap<boolean[][], Integer> mapTopoPositions = new TCustomHashMap<boolean[][], Integer>(new MatrixArrayStrategy());
        String direction = "undir";
        if (directed) {
            direction = "dir";
        }
        String topologyFile = "Topologies/" + direction + motifSize + ".str";
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(topologyFile)));
            String str = "";
            while ((str = br.readLine()) != null) {
                boolean[][] initAdjMat = GraphUtility.getAdjMatrix(str);
                boolean[][] finalAdjMat = GraphUtility.getCanonAdj(initAdjMat);
                mapTopoPositions.put(finalAdjMat, 0);
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        Iterator<boolean[][]> it = mapTopoPositions.keySet().iterator();
        int cont = 0;
        while (it.hasNext()) {
            boolean[][] adjMotif = it.next();
            mapTopoPositions.put(adjMotif, cont);
            ++cont;
        }
        return mapTopoPositions;
    }

    public Vector<boolean[][]> readMotifs(String motifFile, TCustomHashMap<boolean[][], Integer> mapTopoPositions) {
        Vector<boolean[][]> setTopologies = new Vector<boolean[][]>();
        if (motifFile == null) {
            Iterator<boolean[][]> it = mapTopoPositions.keySet().iterator();
            while (it.hasNext()) {
                setTopologies.add(it.next());
            }
        } else {
            try {
                BufferedReader br = new BufferedReader(new FileReader(motifFile));
                String str = "";
                while ((str = br.readLine()) != null) {
                    boolean[][] initAdjMat = GraphUtility.getAdjMatrix(str);
                    boolean[][] finalAdjMat = GraphUtility.getCanonAdj(initAdjMat);
                    setTopologies.add(finalAdjMat);
                }
                br.close();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return setTopologies;
    }

    public void writeMotifResults(TCustomHashMap<int[], double[]>[] mapMotifsInfo, Vector<boolean[][]> setTopologies, String outputFile, boolean extended) {
        int numMotifs = 0;
        int numTotalOccs = 0;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
            bw.write("Motif (Topology:nodeColors)\tNum_occ_input_graph\tMean_analytical\tVariance_analytical\tPval_analytical");
            if (extended) {
                bw.write("\tMean_simulation\tPval_simulation\n");
            } else {
                bw.write("\n");
            }
            for (int i = 0; i < mapMotifsInfo.length; ++i) {
                boolean[][] adjTopo = setTopologies.get(i);
                String strTopo = GraphUtility.getAdjString(adjTopo);
                for (int[] setColors : mapMotifsInfo[i].keySet()) {
                    String strCol = "";
                    int j = 0;
                    for (j = 0; j < setColors.length - 1; ++j) {
                        strCol = strCol + setColors[j] + ",";
                    }
                    strCol = strCol + setColors[j];
                    double[] motifInfo = mapMotifsInfo[i].get(setColors);
                    numTotalOccs = (int)((double)numTotalOccs + motifInfo[0]);
                    bw.write(strTopo + ":" + strCol + "\t" + (long)motifInfo[0] + "\t" + motifInfo[1] + "\t" + motifInfo[2] + "\t" + motifInfo[3]);
                    if (extended) {
                        bw.write("\t" + motifInfo[4] + "\t" + motifInfo[5] + "\n");
                    } else {
                        bw.write("\n");
                    }
                    ++numMotifs;
                }
            }
            bw.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        System.out.println("Done! Found " + numMotifs + " motifs and a total number of " + numTotalOccs + " occurrences");
        System.out.println("Results written in " + outputFile);
    }

    public void savePlotToPDFFile(JFreeChart chart, String pdfFile) {
        try {
            File f = new File(pdfFile);
            this.saveChartAsPDF(f, chart, 800, 500, new DefaultFontMapper());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void writeChartAsPDF(OutputStream out, JFreeChart chart, int width, int height, FontMapper mapper) {
        Rectangle pagesize = new Rectangle(width, height);
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            PdfWriter writer = PdfWriter.getInstance(document, out);
            document.addAuthor("Micale");
            document.addSubject("Prova");
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate(width, height);
            Graphics2D g2 = tp.createGraphics(width, height, mapper);
            Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, width, height);
            chart.draw(g2, r2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
        catch (DocumentException e) {
            System.out.println(e.getMessage());
        }
        document.close();
    }

    public void saveChartAsPDF(File file, JFreeChart chart, int width, int height, FontMapper mapper) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            this.writeChartAsPDF(out, chart, width, height, mapper);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

