/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.Vector;

public class EDDMultiset
extends EDDModel {
    public EDDMultiset(int numNodes, boolean directed, double[] freqColors, boolean dependent, double[] degreeDistrOut, double[] degreeDistrIn, double[][] colorsDistrOut, double[][] colorsDistrIn) {
        super(numNodes, directed, freqColors, dependent, degreeDistrOut, degreeDistrIn, colorsDistrOut, colorsDistrIn);
    }

    public double computeOccProbTopology(boolean[][] adjMotif) {
        int numEdgesMotif = 0;
        if (this.directed) {
            int[] outDegrees = new int[adjMotif.length];
            int[] inDegrees = new int[adjMotif.length];
            int i = 0;
            int j = 0;
            for (i = 0; i < adjMotif.length; ++i) {
                for (j = 0; j < adjMotif.length; ++j) {
                    if (!adjMotif[i][j]) continue;
                    ++numEdgesMotif;
                    int n = i;
                    outDegrees[n] = outDegrees[n] + 1;
                    int n2 = j;
                    inDegrees[n2] = inDegrees[n2] + 1;
                }
            }
            double probTopology = this.gammaPowers[numEdgesMotif];
            for (i = 0; i < adjMotif.length; ++i) {
                probTopology = probTopology * this.momentsOut[outDegrees[i]] * this.momentsIn[inDegrees[i]];
            }
            return probTopology;
        }
        int[] outDegrees = new int[adjMotif.length];
        int i = 0;
        int j = 0;
        for (i = 0; i < adjMotif.length; ++i) {
            for (j = i + 1; j < adjMotif.length; ++j) {
                if (!adjMotif[i][j]) continue;
                ++numEdgesMotif;
                int n = i;
                outDegrees[n] = outDegrees[n] + 1;
                int n3 = j;
                outDegrees[n3] = outDegrees[n3] + 1;
            }
        }
        double probTopology = this.gammaPowers[numEdgesMotif];
        for (i = 0; i < adjMotif.length; ++i) {
            probTopology *= this.momentsOut[outDegrees[i]];
        }
        return probTopology;
    }

    public double computeOccProbColors(int[] setColors) {
        int[] multiplicitiesMotif = new int[this.freqColors.length];
        int i = 0;
        double probColors = 1.0;
        for (i = 0; i < setColors.length; ++i) {
            int n = setColors[i] - 1;
            multiplicitiesMotif[n] = multiplicitiesMotif[n] + 1;
            probColors *= this.freqColors[setColors[i] - 1];
        }
        return probColors *= MathUtility.multinomCoeff(setColors.length, multiplicitiesMotif);
    }

    @Override
    public double computeMean(Vector<boolean[][]> nrPerm, int[] setColors) {
        boolean[][] adjMotif = nrPerm.get(0);
        int roPerm = nrPerm.size();
        double binomCoeff = MathUtility.binomCoeff(this.numNodes, setColors.length);
        double probTopology = this.computeOccProbTopology(adjMotif);
        double probColors = this.computeOccProbColors(setColors);
        double mean = binomCoeff * (double)roPerm * probTopology * probColors;
        return mean;
    }

    @Override
    public double computeVariance(Vector<boolean[][]> nrPerm, int[] setColors, double mean, double[] coeffOverlap) {
        int i = 0;
        int j = 0;
        boolean[][] adjMotif = nrPerm.get(0);
        int k = adjMotif.length;
        int numberNRPermutation = nrPerm.size();
        double varPerm = (double)numberNRPermutation * this.computeOccProbTopology(adjMotif) * this.computeOccProbColors(setColors);
        double moment2 = coeffOverlap[0] * varPerm * varPerm;
        double overlappingSum = 0.0;
        for (int s = 1; s <= k; ++s) {
            double probSuperColors = 0.0;
            HashMap<String, Integer> multiplicityColors = MathUtility.getSubsets(setColors, s);
            for (String subsetCol : multiplicityColors.keySet()) {
                String[] split = subsetCol.split(",");
                int[] overlapColors = new int[split.length];
                for (i = 0; i < overlapColors.length; ++i) {
                    overlapColors[i] = Integer.parseInt(split[i]);
                }
                double partialRes = this.computeOccProbColors(overlapColors);
                if (s < k) {
                    int[] nonOverlapColors = MathUtility.setDifference(setColors, overlapColors);
                    partialRes *= Math.pow(this.computeOccProbColors(nonOverlapColors), 2.0);
                }
                probSuperColors += partialRes;
            }
            double probSuperMotif = 0.0;
            for (i = 0; i < nrPerm.size(); ++i) {
                boolean[][] adjSource = nrPerm.get(i);
                for (j = 0; j < nrPerm.size(); ++j) {
                    boolean[][] adjDest = nrPerm.get(j);
                    boolean[][] adjSuper = MathUtility.createSuperMotif(adjSource, adjDest, s);
                    probSuperMotif += this.computeOccProbTopology(adjSuper) * probSuperColors;
                }
            }
            overlappingSum += coeffOverlap[s] * probSuperMotif;
        }
        double variance = (moment2 += overlappingSum) - mean * mean;
        return variance;
    }

    @Override
    public double[] computeSetTopoMeans(Vector<Vector<boolean[][]>> nrPerm) {
        double[] setTopoMeans = new double[nrPerm.size()];
        int i = 0;
        for (i = 0; i < nrPerm.size(); ++i) {
            setTopoMeans[i] = this.computeTopoMean(nrPerm.get(i));
        }
        return setTopoMeans;
    }

    public double computeTopoMean(Vector<boolean[][]> nrPerm) {
        boolean[][] adjMotif = nrPerm.get(0);
        int k = adjMotif.length;
        int roPerm = nrPerm.size();
        double binomCoeff = MathUtility.binomCoeff(this.numNodes, k);
        double probTopology = this.computeOccProbTopology(adjMotif);
        double meanTopo = binomCoeff * (double)roPerm * probTopology;
        return meanTopo;
    }

    @Override
    public double computeMeanInduced(double[] topoMeans, int[] setColors, int[] kocayVals) {
        int i = 0;
        double meanInduced = 0.0;
        double probColors = this.computeOccProbColors(setColors);
        for (i = 0; i < kocayVals.length; ++i) {
            if (kocayVals[i] == 0) continue;
            meanInduced += (double)kocayVals[i] * topoMeans[i] * probColors;
        }
        return meanInduced;
    }

    @Override
    public double[][] computeSetTopoVariances(Vector<Vector<boolean[][]>> nrPerm, int k) {
        double[] coeffOverlap = this.getCoeffOverlap(k);
        double[][] setTopoVariances = new double[nrPerm.size()][k + 1];
        int i = 0;
        for (i = 0; i < nrPerm.size(); ++i) {
            setTopoVariances[i] = this.computeTopoVariance(nrPerm.get(i), coeffOverlap);
        }
        return setTopoVariances;
    }

    public double[] computeTopoVariance(Vector<boolean[][]> nrPerm, double[] coeffOverlap) {
        int i = 0;
        int j = 0;
        boolean l = false;
        boolean m = false;
        boolean[][] adjMotif = nrPerm.get(0);
        int k = adjMotif.length;
        double[] topoVariance = new double[k + 1];
        int numberNRPermutation = nrPerm.size();
        double varTopo = (double)numberNRPermutation * this.computeOccProbTopology(adjMotif);
        topoVariance[0] = coeffOverlap[0] * varTopo * varTopo;
        double overlappingSum = 0.0;
        for (int s = 1; s <= k; ++s) {
            double probSuperMotif = 0.0;
            for (i = 0; i < nrPerm.size(); ++i) {
                boolean[][] adjSource = nrPerm.get(i);
                for (j = 0; j < nrPerm.size(); ++j) {
                    boolean[][] adjDest = nrPerm.get(j);
                    boolean[][] adjSuper = MathUtility.createSuperMotif(adjSource, adjDest, s);
                    probSuperMotif += this.computeOccProbTopology(adjSuper);
                }
            }
            topoVariance[s] = coeffOverlap[s] * probSuperMotif;
        }
        return topoVariance;
    }

    @Override
    public double computeVarianceInduced(Vector<Vector<boolean[][]>> nrPerm, int[] setColors, int[] kocayVals, double[][] topoVariances, double[][] topoCovariances, double[] topoMeans) {
        double varianceInduced = 0.0;
        double probColorsMotif = this.computeOccProbColors(setColors);
        double[] probSuperColors = new double[topoVariances[0].length];
        int i = 0;
        int s = 0;
        for (s = 1; s < probSuperColors.length; ++s) {
            probSuperColors[s] = 0.0;
            HashMap<String, Integer> multiplicityColors = MathUtility.getSubsets(setColors, s);
            for (String subsetCol : multiplicityColors.keySet()) {
                String[] split = subsetCol.split(",");
                int[] overlapColors = new int[split.length];
                for (i = 0; i < overlapColors.length; ++i) {
                    overlapColors[i] = Integer.parseInt(split[i]);
                }
                int multiplicitySubset = multiplicityColors.get(subsetCol);
                double partialRes = this.computeOccProbColors(overlapColors);
                if (s < probSuperColors.length) {
                    int[] nonOverlapColors = MathUtility.setDifference(setColors, overlapColors);
                    partialRes *= Math.pow(this.computeOccProbColors(nonOverlapColors), 2.0);
                }
                int n = s;
                probSuperColors[n] = probSuperColors[n] + partialRes;
            }
        }
        double varTerm = 0.0;
        int j = 0;
        int l = 0;
        for (i = 0; i < kocayVals.length; ++i) {
            if (kocayVals[i] == 0) continue;
            double mean = topoMeans[i] * probColorsMotif;
            double variance = this.computeMoment2Preproc(topoVariances[i], probColorsMotif, probSuperColors) - mean * mean;
            varTerm += (double)(kocayVals[i] * kocayVals[i]) * variance;
        }
        varianceInduced += varTerm;
        double covarTerm = 0.0;
        for (i = 0; i < nrPerm.size(); ++i) {
            if (kocayVals[i] != 0) {
                for (j = i + 1; j < nrPerm.size(); ++j) {
                    if (kocayVals[j] != 0) {
                        double mean1 = topoMeans[i] * probColorsMotif;
                        double mean2 = topoMeans[j] * probColorsMotif;
                        double covariance = this.computeCovarianceInduced(nrPerm.get(i), nrPerm.get(j), topoCovariances[l], probColorsMotif, probSuperColors) - mean1 * mean2;
                        covarTerm += (double)(kocayVals[i] * kocayVals[j]) * covariance;
                    }
                    ++l;
                }
                continue;
            }
            for (j = i + 1; j < nrPerm.size(); ++j) {
                ++l;
            }
        }
        return varianceInduced += (covarTerm *= 2.0);
    }

    public double computeMoment2Preproc(double[] topoVariance, double probColorsMotif, double[] probSuperColors) {
        double res = topoVariance[0] * probColorsMotif * probColorsMotif;
        double coeff = 0.0;
        double overlappingSum = 0.0;
        for (int s = 1; s < topoVariance.length; ++s) {
            double probSuperMotif = topoVariance[s];
            overlappingSum += topoVariance[s] * probSuperColors[s];
        }
        return res += overlappingSum;
    }

    @Override
    public double[][] computeSetTopoCovariances(Vector<Vector<boolean[][]>> nrPerm, int k) {
        double[] coeffOverlap = this.getCoeffOverlap(k);
        double[][] setTopoCovariances = new double[nrPerm.size() * (nrPerm.size() - 1) / 2][k + 1];
        int i = 0;
        int j = 0;
        int l = 0;
        for (i = 0; i < nrPerm.size(); ++i) {
            for (j = i + 1; j < nrPerm.size(); ++j) {
                setTopoCovariances[l] = this.computeTopoCovariance(nrPerm.get(i), nrPerm.get(j), coeffOverlap);
                ++l;
            }
        }
        return setTopoCovariances;
    }

    public double[] computeTopoCovariance(Vector<boolean[][]> nrPerm1, Vector<boolean[][]> nrPerm2, double[] coeffOverlap) {
        int k = nrPerm1.get(0).length;
        double[] setTopoCovariance = new double[k + 1];
        double muSum = 0.0;
        int i = 0;
        int j = 0;
        boolean l = false;
        double[] probTopo1 = new double[nrPerm1.size()];
        double[] probTopo2 = new double[nrPerm2.size()];
        for (i = 0; i < nrPerm1.size(); ++i) {
            boolean[][] adjMotif1 = nrPerm1.get(i);
            probTopo1[i] = this.computeOccProbTopology(adjMotif1);
        }
        for (i = 0; i < nrPerm2.size(); ++i) {
            boolean[][] adjMotif2 = nrPerm2.get(i);
            probTopo2[i] = this.computeOccProbTopology(adjMotif2);
        }
        for (i = 0; i < nrPerm1.size(); ++i) {
            for (j = 0; j < nrPerm2.size(); ++j) {
                muSum += probTopo1[i] * probTopo2[j];
            }
        }
        setTopoCovariance[0] = coeffOverlap[0] * muSum;
        for (int s = 1; s <= k; ++s) {
            double probSuperTopology = 0.0;
            for (i = 0; i < nrPerm1.size(); ++i) {
                boolean[][] adjSource = nrPerm1.get(i);
                for (j = 0; j < nrPerm2.size(); ++j) {
                    boolean[][] adjDest = nrPerm2.get(j);
                    boolean[][] adjSuper = MathUtility.createSuperMotif(adjSource, adjDest, s);
                    probSuperTopology += this.computeOccProbTopology(adjSuper);
                }
            }
            setTopoCovariance[s] = coeffOverlap[s] * probSuperTopology;
        }
        return setTopoCovariance;
    }

    public double computeCovarianceInduced(Vector<boolean[][]> nrPerm1, Vector<boolean[][]> nrPerm2, double[] topoCovariance, double probColorsMotif, double[] probSuperColors) {
        double covariance = 0.0;
        covariance += topoCovariance[0] * probColorsMotif * probColorsMotif;
        double overlappingSum = 0.0;
        int s = 0;
        for (s = 1; s < topoCovariance.length; ++s) {
            overlappingSum += topoCovariance[s] * probSuperColors[s];
        }
        return covariance += overlappingSum;
    }
}

