/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;

public class EDDModel {
    protected int numNodes;
    protected boolean directed;
    protected double[] freqColors;
    protected double[] gammaPowers;
    protected double[] degreeDistrOut;
    protected double[] degreeDistrIn;
    protected double[][] colorsDistrOut;
    protected double[][] colorsDistrIn;
    protected boolean dependent;
    protected double[] momentsOut;
    protected double[] momentsIn;
    protected double[][] momentsColorsOut;
    protected double[][] momentsColorsIn;

    public EDDModel(int numNodes, boolean directed, double[] freqColors, boolean dependent, double[] degreeDistrOut, double[] degreeDistrIn, double[][] colorsDistrOut, double[][] colorsDistrIn) {
        this.numNodes = numNodes;
        this.directed = directed;
        this.freqColors = freqColors;
        this.dependent = dependent;
        this.degreeDistrOut = degreeDistrOut;
        this.degreeDistrIn = degreeDistrIn;
        this.colorsDistrOut = colorsDistrOut;
        this.colorsDistrIn = colorsDistrIn;
    }

    public Graph sampleGraph(int[] colorList) {
        Random r = new Random();
        int i = 0;
        int j = 0;
        boolean k = false;
        boolean l = false;
        Graph g = new Graph(this.directed, this.numNodes, colorList);
        double[] outDegrees = new double[this.numNodes];
        double[] inDegrees = new double[this.numNodes];
        int[] sampledOutDegrees = this.dependent ? MathUtility.sampleMultinomial(colorList, this.colorsDistrOut) : MathUtility.sampleMultinomial(this.numNodes, this.degreeDistrOut);
        for (i = 0; i < sampledOutDegrees.length; ++i) {
            outDegrees[i] = sampledOutDegrees[i];
        }
        if (this.directed) {
            int[] sampledInDegrees = this.dependent ? MathUtility.sampleMultinomial(colorList, this.colorsDistrIn) : MathUtility.sampleMultinomial(this.numNodes, this.degreeDistrIn);
            for (i = 0; i < sampledInDegrees.length; ++i) {
                inDegrees[i] = sampledInDegrees[i];
            }
        } else {
            for (i = 0; i < sampledOutDegrees.length; ++i) {
                inDegrees[i] = sampledOutDegrees[i];
            }
        }
        double meanDegree = 0.0;
        if (this.dependent) {
            for (i = 0; i < this.colorsDistrOut.length; ++i) {
                for (j = 0; j < this.colorsDistrOut[i].length; ++j) {
                    meanDegree += this.colorsDistrOut[i][j] * this.freqColors[i] * (double)j;
                }
            }
        } else {
            for (i = 0; i < this.degreeDistrOut.length; ++i) {
                meanDegree += this.degreeDistrOut[i] * (double)i;
            }
        }
        double gamma = 1.0 / ((double)(this.numNodes - 1) * meanDegree);
        for (i = 0; i < this.numNodes; ++i) {
            for (j = 0; j < this.numNodes; ++j) {
                if (j == i || !this.directed && i >= j) continue;
                double probRef = outDegrees[i] * inDegrees[j] * gamma;
                double randNum = r.nextDouble();
                if (!(randNum < probRef)) continue;
                g.addEdge(i, j);
            }
        }
        return g;
    }

    public void setMoments(int degree) {
        if (this.dependent) {
            this.momentsColorsOut = new double[this.colorsDistrOut.length][degree + 1];
            this.momentsColorsIn = new double[this.colorsDistrIn.length][degree + 1];
            int i = 0;
            int j = 0;
            int k = 0;
            for (i = 0; i < this.momentsColorsOut.length; ++i) {
                this.momentsColorsOut[i][0] = 1.0;
                this.momentsColorsIn[i][0] = 1.0;
            }
            for (i = 0; i < this.momentsColorsOut.length; ++i) {
                for (j = 1; j < this.momentsColorsOut[i].length; ++j) {
                    this.momentsColorsOut[i][j] = 0.0;
                    this.momentsColorsIn[i][j] = 0.0;
                    for (k = 0; k < this.colorsDistrOut[i].length; ++k) {
                        double[] dArray = this.momentsColorsOut[i];
                        int n = j;
                        dArray[n] = dArray[n] + this.colorsDistrOut[i][k] * Math.pow(k, j);
                    }
                    for (k = 0; k < this.colorsDistrIn[i].length; ++k) {
                        double[] dArray = this.momentsColorsIn[i];
                        int n = j;
                        dArray[n] = dArray[n] + this.colorsDistrIn[i][k] * Math.pow(k, j);
                    }
                }
            }
        } else {
            this.momentsOut = new double[degree + 1];
            this.momentsIn = new double[degree + 1];
            int i = 0;
            int j = 0;
            this.momentsOut[0] = 1.0;
            this.momentsIn[0] = 1.0;
            for (i = 1; i < this.momentsOut.length; ++i) {
                this.momentsOut[i] = 0.0;
                this.momentsIn[i] = 0.0;
                for (j = 0; j < this.degreeDistrOut.length; ++j) {
                    int n = i;
                    this.momentsOut[n] = this.momentsOut[n] + this.degreeDistrOut[j] * Math.pow(j, i);
                }
                for (j = 0; j < this.degreeDistrIn.length; ++j) {
                    int n = i;
                    this.momentsIn[n] = this.momentsIn[n] + this.degreeDistrIn[j] * Math.pow(j, i);
                }
            }
        }
    }

    public void setGammaPowers(int degree) {
        if (this.dependent) {
            this.gammaPowers = new double[degree + 1];
            this.gammaPowers[0] = 1.0;
            double meanDegree = 0.0;
            int i = 0;
            int j = 0;
            for (i = 0; i < this.colorsDistrOut.length; ++i) {
                for (j = 0; j < this.colorsDistrOut[i].length; ++j) {
                    meanDegree += this.colorsDistrOut[i][j] * this.freqColors[i] * (double)j;
                }
            }
            this.gammaPowers[1] = 1.0 / ((double)(this.numNodes - 1) * meanDegree);
            for (i = 2; i < this.gammaPowers.length; ++i) {
                this.gammaPowers[i] = Math.pow(this.gammaPowers[1], i);
            }
        } else {
            this.gammaPowers = new double[degree + 1];
            this.gammaPowers[0] = 1.0;
            this.gammaPowers[1] = 1.0 / ((double)(this.numNodes - 1) * this.momentsOut[1]);
            int i = 0;
            for (i = 2; i < this.gammaPowers.length; ++i) {
                this.gammaPowers[i] = Math.pow(this.gammaPowers[1], i);
            }
        }
    }

    public double[] getCoeffOverlap(int k) {
        double[] coeffOverlap = new double[k + 1];
        int[] paramMulti = new int[3];
        paramMulti[0] = this.numNodes - 2 * k;
        paramMulti[1] = paramMulti[2] = k;
        coeffOverlap[0] = MathUtility.multinomCoeff(this.numNodes, paramMulti);
        paramMulti = new int[4];
        int s = 0;
        for (s = 1; s <= k; ++s) {
            paramMulti[0] = k - s;
            paramMulti[1] = s;
            paramMulti[2] = k - s;
            paramMulti[3] = this.numNodes - 2 * k + s;
            coeffOverlap[s] = MathUtility.multinomCoeff(this.numNodes, paramMulti);
        }
        return coeffOverlap;
    }

    public double computeMean(Vector<boolean[][]> nrPerm, int[] setColors) {
        return 0.0;
    }

    public double computeVariance(Vector<boolean[][]> nrPerm, int[] setColors, double mean, double[] coeffOverlap) {
        return 0.0;
    }

    public double computeMeanInduced(double[] topoMeans, int[] setColors, int[] kocayVals) {
        return 0.0;
    }

    public double computeVarianceInduced(Vector<Vector<boolean[][]>> nrPerm, int[] setColors, int[] kocayVals, double[][] topoVariances, double[][] topoCovariances, double[] topoMeans) {
        return 0.0;
    }

    public double[] computeSetTopoMeans(Vector<Vector<boolean[][]>> nrPerm) {
        return null;
    }

    public double[][] computeSetTopoVariances(Vector<Vector<boolean[][]>> nrPerm, int k) {
        return null;
    }

    public double[][] computeSetTopoCovariances(Vector<Vector<boolean[][]>> nrPerm, int k) {
        return null;
    }

    public double computeMean(Vector<ColPermutation> nrPerm) {
        return 0.0;
    }

    public double computeVariance(Vector<ColPermutation> nrPerm, double mean, double[] coeffOverlap) {
        return 0.0;
    }

    public double[] computeSetMeans(Vector<ColPermutation>[] nrPerm) {
        return null;
    }

    public double[] computeSetVariances(Vector<ColPermutation>[] nrPerm, double[] setMeans, double[] coeffOverlap) {
        return null;
    }

    public double[] computeSetCovariances(Vector<ColPermutation>[] nrPerm, double[] coeffOverlap) {
        return null;
    }

    public double computeMeanInducedPreproc(int[] kocayInv, double[] setMeans) {
        return 0.0;
    }

    public double computeVarianceInducedPreproc(int[] kocayInv, double[] setVariances, double[] setCovariances, double[] coeffOverlap) {
        return 0.0;
    }
}

