/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class RIGraph {
    public int[] colors;
    private int numColors;
    public Vector<Integer>[] outAdiacs;
    public Vector<Integer>[] inAdiacs;
    private boolean directed;

    public RIGraph(boolean[][] adjMatrix, int[] colors, boolean directed) {
        this.colors = colors;
        this.directed = directed;
        int i = 0;
        int j = 0;
        int maxCol = 0;
        for (i = 0; i < colors.length; ++i) {
            if (colors[i] <= maxCol) continue;
            maxCol = colors[i];
        }
        this.numColors = maxCol;
        this.outAdiacs = new Vector[colors.length];
        this.inAdiacs = new Vector[colors.length];
        for (i = 0; i < colors.length; ++i) {
            this.outAdiacs[i] = new Vector();
            this.inAdiacs[i] = new Vector();
        }
        for (i = 0; i < colors.length; ++i) {
            for (j = 0; j < colors.length; ++j) {
                if (!adjMatrix[i][j]) continue;
                this.outAdiacs[i].add(j);
                this.inAdiacs[j].add(i);
            }
        }
    }

    public int getNumNodes() {
        return this.colors.length;
    }

    public int[] getColors() {
        return this.colors;
    }

    public int getNumColors() {
        return this.numColors;
    }

    public Vector<Integer>[] getSetsOutAdiacs() {
        return this.outAdiacs;
    }

    public Vector<Integer>[] getSetsInAdiacs() {
        return this.inAdiacs;
    }

    public boolean isDirected() {
        return this.directed;
    }
}

