/*
 * Decompiled with CFR 0.152.
 */
import gnu.trove.map.custom_hash.TObjectLongCustomHashMap;
import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.set.hash.TCustomHashSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;

public class MotifManager {
    private int motifSize;
    private boolean directed;
    private int[] colorConstr;
    private boolean injective;
    private boolean induced;
    private boolean dependent;

    public MotifManager(int motifSize, boolean directed, int[] colorConstr, boolean injective, boolean induced, boolean dependent) {
        this.motifSize = motifSize;
        this.directed = directed;
        this.colorConstr = colorConstr;
        this.injective = injective;
        this.induced = induced;
        this.dependent = dependent;
    }

    public EDDModel setupEDDModel(Graph net) {
        double[] freqColors = net.getFreqColors();
        int numNodes = net.getNumNodes();
        double[][] distr = net.getDegreeDistributions();
        double[][][] colorDegreeDistr = net.getColorsDegreeDistributions();
        EDDModel edd = !this.dependent && !this.injective ? new EDDMultiset(numNodes, this.directed, freqColors, this.dependent, distr[0], distr[1], colorDegreeDistr[0], colorDegreeDistr[1]) : new EDDInjective(numNodes, this.directed, freqColors, this.dependent, distr[0], distr[1], colorDegreeDistr[0], colorDegreeDistr[1]);
        edd.setMoments(2 * this.motifSize - 2);
        edd.setGammaPowers((2 * this.motifSize - 2) * (2 * this.motifSize - 2));
        return edd;
    }

    public TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> censusGraph(GTrie gt, Graph net, Vector<boolean[][]> setTopologies, int[][] kocayMat, TCustomHashMap<boolean[][], Integer> mapTopoPositions) {
        int[] colors = net.getColorList();
        if (!this.dependent && !this.injective) {
            gt.census(net, colors, this.colorConstr, this.directed, this.motifSize, false);
        } else {
            gt.census(net, colors, this.colorConstr, this.directed, this.motifSize, true);
        }
        TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> mapFreqs = gt.getMotifFrequencies();
        if (!this.induced) {
            int startPoint = 0;
            int i = 0;
            for (i = 0; i < this.colorConstr.length && this.colorConstr[i] != 0; ++i) {
            }
            startPoint = i;
            int[] colorConstrComplete = new int[this.motifSize];
            for (i = 0; i < this.colorConstr.length; ++i) {
                colorConstrComplete[i] = this.colorConstr[i];
            }
            Vector<int[]> colorConstraints = MathUtility.fillQuery(net.getNumColors(), startPoint, colorConstrComplete);
            if (!this.dependent && !this.injective) {
                this.fillMap(mapFreqs, colorConstraints, false);
                mapFreqs = this.computeNonInducedFreqs(mapFreqs, kocayMat, setTopologies, false, mapTopoPositions);
            } else {
                this.fillMap(mapFreqs, colorConstraints, true);
                mapFreqs = this.computeNonInducedFreqs(mapFreqs, kocayMat, setTopologies, true, mapTopoPositions);
            }
        }
        if (this.injective || this.dependent) {
            mapFreqs = this.aggregateFrequencies(mapFreqs);
        }
        return mapFreqs;
    }

    public void fillMap(TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> mapFreqs, Vector<int[]> colorConstraints, boolean isInjective) {
        Iterator<boolean[][]> it = mapFreqs.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            boolean[][] adjQuery = it.next();
            TObjectLongCustomHashMap<int[]> mapColorsQuery = mapFreqs.get(adjQuery);
            Vector<int[]> autosUncolored = GraphUtility.findAutomorphisms(adjQuery);
            Vector<Integer>[] symmCondUncolored = GraphUtility.getSymmetryConditions(adjQuery, autosUncolored);
            for (i = 0; i < colorConstraints.size(); ++i) {
                TCustomHashSet<int[]> permutations = new TCustomHashSet<int[]>(new IntArrayStrategy());
                if (isInjective) {
                    GraphUtility.getSetsColorsTopo(permutations, colorConstraints.get(i), symmCondUncolored);
                } else {
                    permutations.add(colorConstraints.get(i));
                }
                for (int[] setColorsArrangement : permutations) {
                    if (mapColorsQuery.containsKey(setColorsArrangement)) continue;
                    mapColorsQuery.put(setColorsArrangement, 0L);
                }
            }
        }
    }

    private TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> computeNonInducedFreqs(TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> mapMotifs, int[][] kocayMat, Vector<boolean[][]> setTopologies, boolean isInjective, TCustomHashMap<boolean[][], Integer> mapTopoPositions) {
        TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> newMapMotifs = new TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>>(new MatrixArrayStrategy());
        if (!isInjective) {
            int i = 0;
            for (i = 0; i < setTopologies.size(); ++i) {
                boolean[][] adjQuery = setTopologies.get(i);
                int indexTopo = mapTopoPositions.get(adjQuery);
                TObjectLongCustomHashMap<int[]> newMapCounts = new TObjectLongCustomHashMap<int[]>(new IntArrayStrategy());
                TObjectLongCustomHashMap<int[]> mapCountsSource = mapMotifs.get(adjQuery);
                for (int[] colorQuery : mapCountsSource.keySet()) {
                    long numOccNonInducedQuery = mapCountsSource.get(colorQuery);
                    for (boolean[][] adjTarget : mapMotifs.keySet()) {
                        int j = mapTopoPositions.get(adjTarget);
                        if (j == indexTopo || kocayMat[indexTopo][j] == 0) continue;
                        TObjectLongCustomHashMap<int[]> mapCountsTarget = mapMotifs.get(adjTarget);
                        numOccNonInducedQuery += (long)kocayMat[indexTopo][j] * mapCountsTarget.get(colorQuery);
                    }
                    if (numOccNonInducedQuery <= 0L) continue;
                    newMapCounts.put(colorQuery, numOccNonInducedQuery);
                }
                if (newMapCounts.size() <= 0) continue;
                newMapMotifs.put(adjQuery, newMapCounts);
            }
        } else {
            int i = 0;
            for (i = 0; i < setTopologies.size(); ++i) {
                boolean[][] adjQuery = setTopologies.get(i);
                int indexTopo = mapTopoPositions.get(adjQuery);
                Vector<int[]> autosUncolored = GraphUtility.findAutomorphisms(adjQuery);
                Vector<Integer>[] symmCondUncolored = GraphUtility.getSymmetryConditions(adjQuery, autosUncolored);
                TObjectLongCustomHashMap<int[]> newMapCounts = new TObjectLongCustomHashMap<int[]>(new IntArrayStrategy());
                TObjectLongCustomHashMap<int[]> mapCountsSource = mapMotifs.get(adjQuery);
                for (int[] colorQuery : mapCountsSource.keySet()) {
                    long numOccNonInducedQuery = mapCountsSource.get(colorQuery);
                    RIGraph query = new RIGraph(adjQuery, colorQuery, this.directed);
                    MatchingMachine mama = new MatchingMachine(query);
                    mama.build(query);
                    for (boolean[][] adjTarget : mapMotifs.keySet()) {
                        int j = mapTopoPositions.get(adjTarget);
                        if (j == indexTopo || kocayMat[indexTopo][j] == 0 || !mapMotifs.containsKey(adjTarget)) continue;
                        TObjectLongCustomHashMap<int[]> mapCountsTarget = mapMotifs.get(adjTarget);
                        for (int[] colorPerm : mapCountsTarget.keySet()) {
                            long numOccInducedTarget = mapCountsTarget.get(colorPerm);
                            if (numOccInducedTarget <= 0L) continue;
                            RIGraph target = new RIGraph(adjTarget, colorPerm, this.directed);
                            RISolver sol = new RISolver(mama, target, query, true, symmCondUncolored);
                            sol.solve();
                            int kocayCoeff = sol.numMatches;
                            numOccNonInducedQuery += (long)kocayCoeff * numOccInducedTarget;
                        }
                    }
                    if (numOccNonInducedQuery <= 0L) continue;
                    newMapCounts.put(colorQuery, numOccNonInducedQuery);
                }
                if (newMapCounts.size() <= 0) continue;
                newMapMotifs.put(adjQuery, newMapCounts);
            }
        }
        return newMapMotifs;
    }

    public int getSetRecurrentMotifs(TCustomHashMap<int[], double[]>[] mapMotifsInfo, Vector<boolean[][]> setTopologies, TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> mapFreqs, int minFreq, int numInfo) {
        int i = 0;
        int numMotifs = 0;
        for (i = 0; i < setTopologies.size(); ++i) {
            boolean[][] adjMotif = setTopologies.get(i);
            mapMotifsInfo[i] = new TCustomHashMap(new IntArrayStrategy());
            if (!mapFreqs.containsKey(adjMotif)) continue;
            TObjectLongCustomHashMap<int[]> mapColCounts = mapFreqs.get(adjMotif);
            for (int[] setColors : mapColCounts.keySet()) {
                long motifFreq = mapColCounts.get(setColors);
                if (motifFreq < (long)minFreq) continue;
                double[] motifInfo = new double[numInfo];
                motifInfo[0] = motifFreq;
                mapMotifsInfo[i].put(setColors, motifInfo);
                ++numMotifs;
            }
        }
        return numMotifs;
    }

    public TCustomHashMap<int[], double[]>[] computeAnalyticalPValues(EDDModel edd, Graph net, TCustomHashMap<int[], double[]>[] mapMotifsInfo, Vector<boolean[][]> setTopologies, TCustomHashMap<boolean[][], Integer> mapTopoPositions, int[][] kocayMat, int numMotifs, double pvalThresh) {
        double[] coeffOverlap = edd.getCoeffOverlap(this.motifSize);
        int i = 0;
        int j = 0;
        int k = 0;
        boolean l = false;
        System.out.println("Computing analytical p-values... 0%");
        double status = 0.1;
        double numProcessedMotifs = 0.0;
        if (!this.dependent && !this.injective) {
            Vector<Vector<boolean[][]>> nonRedPerm = new Vector<Vector<boolean[][]>>();
            for (boolean[][] adjMotif : mapTopoPositions.keySet()) {
                nonRedPerm.add(MathUtility.getNonRedPerm(adjMotif));
            }
            double[] topoMeans = null;
            double[][] topoVariances = null;
            double[][] topoCovariances = null;
            int[][] kocayInv = null;
            if (this.induced) {
                topoMeans = edd.computeSetTopoMeans(nonRedPerm);
                topoVariances = edd.computeSetTopoVariances(nonRedPerm, this.motifSize);
                topoCovariances = edd.computeSetTopoCovariances(nonRedPerm, this.motifSize);
                kocayInv = MathUtility.invertMatrix(kocayMat);
            }
            for (i = 0; i < mapMotifsInfo.length; ++i) {
                Iterator<int[]> it = mapMotifsInfo[i].keySet().iterator();
                int indexTopo = mapTopoPositions.get(setTopologies.get(i));
                while (it.hasNext()) {
                    int[] setColMotif = it.next();
                    double mean = 0.0;
                    double variance = 0.0;
                    if (this.induced) {
                        mean = edd.computeMeanInduced(topoMeans, setColMotif, kocayInv[indexTopo]);
                        variance = edd.computeVarianceInduced(nonRedPerm, setColMotif, kocayInv[indexTopo], topoVariances, topoCovariances, topoMeans);
                    } else {
                        mean = edd.computeMean(nonRedPerm.get(indexTopo), setColMotif);
                        variance = edd.computeVariance(nonRedPerm.get(indexTopo), setColMotif, mean, coeffOverlap);
                    }
                    double a = (variance - mean) / (mean + variance);
                    double lambda = (1.0 - a) * mean;
                    PolyaAeppli pa = new PolyaAeppli(a, lambda);
                    double[] motifInfo = mapMotifsInfo[i].get(setColMotif);
                    long occTarget = (long)motifInfo[0];
                    double pval = 1.0 - pa.lowertail(occTarget);
                    if (pval < -1.0E-17) {
                        pval = 0.0;
                    } else if (pval > 1.0) {
                        pval = 1.0;
                    }
                    motifInfo[1] = mean;
                    motifInfo[2] = variance;
                    motifInfo[3] = pval;
                    if (pval > pvalThresh) {
                        it.remove();
                    }
                    if (!((numProcessedMotifs += 1.0) / (double)numMotifs >= status)) continue;
                    System.out.println("Computing analytical p-values... " + (int)Math.round(status * 100.0) + "%");
                    status += 0.1;
                }
            }
        } else if (this.induced) {
            int numColors = net.getNumColors();
            int startPoint = 0;
            for (i = 0; i < this.colorConstr.length && this.colorConstr[i] != 0; ++i) {
            }
            startPoint = i;
            int[] colorConstrComplete = new int[this.motifSize];
            for (i = 0; i < this.colorConstr.length; ++i) {
                colorConstrComplete[i] = this.colorConstr[i];
            }
            Vector<int[]> setCompQuery = MathUtility.fillQuery(net.getNumColors(), startPoint, colorConstrComplete);
            for (i = 0; i < setCompQuery.size(); ++i) {
                int[] compQuery = setCompQuery.get(i);
                TCustomHashSet<int[]> colorPerms = MathUtility.getColorPermutations(compQuery);
                for (int[] setColors : colorPerms) {
                    for (j = 0; j < mapMotifsInfo.length && !mapMotifsInfo[j].containsKey(setColors); ++j) {
                    }
                    if (j >= mapMotifsInfo.length) continue;
                    Vector[] nonRedPerm = new Vector[mapTopoPositions.size()];
                    int[][] colorKocayMat = new int[mapTopoPositions.size()][mapTopoPositions.size()];
                    for (boolean[][] adjQuery : mapTopoPositions.keySet()) {
                        j = mapTopoPositions.get(adjQuery);
                        nonRedPerm[j] = MathUtility.getNonRedPerm(adjQuery, setColors);
                        RIGraph query = new RIGraph(adjQuery, setColors, this.directed);
                        Vector<int[]> autos = GraphUtility.findAutomorphisms(adjQuery);
                        Vector<Integer>[] symmCond = GraphUtility.getSymmetryConditions(adjQuery, autos);
                        for (boolean[][] adjTarget : mapTopoPositions.keySet()) {
                            k = mapTopoPositions.get(adjTarget);
                            if (kocayMat[j][k] == 0) continue;
                            RIGraph target = new RIGraph(adjTarget, setColors, this.directed);
                            MatchingMachine mama = new MatchingMachine(query);
                            mama.build(query);
                            RISolver sol = new RISolver(mama, target, query, true, symmCond);
                            sol.solve();
                            colorKocayMat[j][k] = sol.numMatches;
                        }
                    }
                    int[][] kocayInv = MathUtility.invertMatrix(colorKocayMat);
                    double[] setMeans = edd.computeSetMeans(nonRedPerm);
                    double[] setVariances = edd.computeSetVariances(nonRedPerm, setMeans, coeffOverlap);
                    double[] setCovariances = edd.computeSetCovariances(nonRedPerm, coeffOverlap);
                    for (j = 0; j < setTopologies.size(); ++j) {
                        double[] motifInfo;
                        long occTarget;
                        double lambda;
                        double variance;
                        double a;
                        PolyaAeppli pa;
                        double pval;
                        if (!mapMotifsInfo[j].containsKey(setColors)) continue;
                        boolean[][] adjMotif = setTopologies.get(j);
                        int indexTopo = mapTopoPositions.get(adjMotif);
                        double mean = edd.computeMeanInducedPreproc(kocayInv[indexTopo], setMeans);
                        if (mean < 0.0) {
                            mean = -mean;
                        }
                        if ((pval = 1.0 - (pa = new PolyaAeppli(a = ((variance = edd.computeVarianceInducedPreproc(kocayInv[indexTopo], setVariances, setCovariances, coeffOverlap)) - mean) / (mean + variance), lambda = (1.0 - a) * mean)).lowertail(occTarget = (long)(motifInfo = mapMotifsInfo[j].get(setColors))[0])) < -1.0E-17) {
                            pval = 0.0;
                        } else if (pval > 1.0) {
                            pval = 1.0;
                        }
                        motifInfo[1] = mean;
                        motifInfo[2] = variance;
                        motifInfo[3] = pval;
                        if ((!this.dependent || this.injective) && pval > pvalThresh) {
                            mapMotifsInfo[j].remove(setColors);
                        }
                        if (!((numProcessedMotifs += 1.0) / (double)numMotifs >= status)) continue;
                        System.out.println("Computing analytical p-values... " + (int)Math.round(status * 100.0) + "%");
                        status += 0.1;
                    }
                }
            }
        } else {
            for (i = 0; i < mapMotifsInfo.length; ++i) {
                boolean[][] adjMotif = setTopologies.get(i);
                Iterator<int[]> it = mapMotifsInfo[i].keySet().iterator();
                while (it.hasNext()) {
                    double[] motifInfo;
                    long occTarget;
                    double lambda;
                    double mean;
                    int[] setColors = it.next();
                    Vector<ColPermutation> nonRedPerm = MathUtility.getNonRedPerm(adjMotif, setColors);
                    double variance = edd.computeVariance(nonRedPerm, mean = edd.computeMean(nonRedPerm), coeffOverlap);
                    double a = (variance - mean) / (mean + variance);
                    PolyaAeppli pa = new PolyaAeppli(a, lambda = (1.0 - a) * mean);
                    double pval = 1.0 - pa.lowertail(occTarget = (long)(motifInfo = mapMotifsInfo[i].get(setColors))[0]);
                    if (pval < -1.0E-17) {
                        pval = 0.0;
                    } else if (pval > 1.0) {
                        pval = 1.0;
                    }
                    motifInfo[1] = mean;
                    motifInfo[2] = variance;
                    motifInfo[3] = pval;
                    if ((!this.dependent || this.injective) && pval > pvalThresh) {
                        it.remove();
                    }
                    if (!((numProcessedMotifs += 1.0) / (double)numMotifs >= status)) continue;
                    System.out.println("Computing analytical p-values... " + (int)Math.round(status * 100.0) + "%");
                    status += 0.1;
                }
            }
        }
        if (this.dependent && !this.injective) {
            mapMotifsInfo = this.aggregateDependentMultiset(mapMotifsInfo, pvalThresh);
        }
        return mapMotifsInfo;
    }

    private TCustomHashMap<int[], double[]>[] aggregateDependentMultiset(TCustomHashMap<int[], double[]>[] mapMotifs, double pvalThresh) {
        int i = 0;
        TCustomHashMap[] newMapMotifs = new TCustomHashMap[mapMotifs.length];
        for (i = 0; i < mapMotifs.length; ++i) {
            newMapMotifs[i] = new TCustomHashMap(new IntArrayStrategy());
            for (int[] colorSet : mapMotifs[i].keySet()) {
                double[] newInfo;
                double[] oldInfo = mapMotifs[i].get(colorSet);
                Arrays.sort(colorSet);
                if (newMapMotifs[i].containsKey(colorSet)) {
                    newInfo = (double[])newMapMotifs[i].get(colorSet);
                    newInfo[0] = newInfo[0] + oldInfo[0];
                    newInfo[1] = newInfo[1] + oldInfo[1];
                    newInfo[2] = newInfo[2] + oldInfo[2];
                    continue;
                }
                newInfo = new double[oldInfo.length];
                newInfo[0] = oldInfo[0];
                newInfo[1] = oldInfo[1];
                newInfo[2] = oldInfo[2];
                newMapMotifs[i].put(colorSet, newInfo);
            }
        }
        for (i = 0; i < newMapMotifs.length; ++i) {
            Iterator<Object> it = newMapMotifs[i].keySet().iterator();
            while (it.hasNext()) {
                long occTarget;
                double lambda;
                double mean;
                int[] colorSet;
                colorSet = (int[])it.next();
                double[] motifInfo = (double[])newMapMotifs[i].get(colorSet);
                double variance = motifInfo[2];
                double a = (variance - (mean = motifInfo[1])) / (mean + variance);
                PolyaAeppli pa = new PolyaAeppli(a, lambda = (1.0 - a) * mean);
                double pval = 1.0 - pa.lowertail(occTarget = (long)motifInfo[0]);
                if (pval < -1.0E-17) {
                    pval = 0.0;
                } else if (pval > 1.0) {
                    pval = 1.0;
                }
                motifInfo[3] = pval;
                if (!(pval > pvalThresh)) continue;
                it.remove();
            }
        }
        return newMapMotifs;
    }

    private TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> aggregateDependentMultisetRand(TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> mapFreqsRand) {
        boolean i = false;
        TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> newMapFreqsRand = new TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>>(new MatrixArrayStrategy());
        for (boolean[][] adjMotif : mapFreqsRand.keySet()) {
            TObjectLongCustomHashMap<int[]> newMapCounts = new TObjectLongCustomHashMap<int[]>(new IntArrayStrategy());
            TObjectLongCustomHashMap<int[]> mapCounts = mapFreqsRand.get(adjMotif);
            for (int[] colorSet : mapCounts.keySet()) {
                long oldNumOcc = mapCounts.get(colorSet);
                Arrays.sort(colorSet);
                newMapCounts.adjustOrPutValue(colorSet, oldNumOcc, oldNumOcc);
            }
            newMapFreqsRand.put(adjMotif, newMapCounts);
        }
        return newMapFreqsRand;
    }

    public TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> aggregateFrequencies(TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> mapFrequencies) {
        TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> newMapFrequencies = new TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>>(new MatrixArrayStrategy());
        for (boolean[][] adjTopo : mapFrequencies.keySet()) {
            Vector<int[]> autos = GraphUtility.findAutomorphisms(adjTopo);
            TObjectLongCustomHashMap<int[]> newMapColors = new TObjectLongCustomHashMap<int[]>(new IntArrayStrategy());
            TObjectLongCustomHashMap<int[]> mapColors = mapFrequencies.get(adjTopo);
            for (int[] colors : mapColors.keySet()) {
                long oldFreq = mapColors.get(colors);
                int[] auto = GraphUtility.selectMinimumAuto(autos, colors);
                int[] newColors = new int[colors.length];
                for (int i = 0; i < newColors.length; ++i) {
                    newColors[i] = colors[auto[i]];
                }
                newMapColors.adjustOrPutValue(newColors, oldFreq, oldFreq);
            }
            newMapFrequencies.put(adjTopo, newMapColors);
        }
        return newMapFrequencies;
    }

    public int[][] buildKocayMatrix(TCustomHashMap<boolean[][], Integer> mapTopoPositions, int motifSize, boolean directed) {
        int[][] kocayMat = new int[mapTopoPositions.size()][mapTopoPositions.size()];
        int[] defSetColors = new int[motifSize];
        for (boolean[][] adjQuery : mapTopoPositions.keySet()) {
            int i = mapTopoPositions.get(adjQuery);
            RIGraph query = new RIGraph(adjQuery, defSetColors, directed);
            Vector<int[]> autosUncolored = GraphUtility.findAutomorphisms(adjQuery);
            Vector<Integer>[] symmCondUncolored = GraphUtility.getSymmetryConditions(adjQuery, autosUncolored);
            for (boolean[][] adjTarget : mapTopoPositions.keySet()) {
                int j = mapTopoPositions.get(adjTarget);
                RIGraph target = new RIGraph(adjTarget, defSetColors, directed);
                MatchingMachine mama = new MatchingMachine(query);
                mama.build(query);
                RISolver sol = new RISolver(mama, target, query, false, symmCondUncolored);
                sol.solve();
                kocayMat[i][j] = sol.numMatches;
            }
        }
        return kocayMat;
    }

    public void computeSimulPValues(EDDModel edd, GTrie gt, Graph net, int numRandVar, Vector<boolean[][]> setTopologies, int[][] kocayMat, TCustomHashMap<boolean[][], Integer> mapTopoPositions, TCustomHashMap<int[], double[]>[] mapMotifsInfo, double pvalThresh) {
        int i = 0;
        int j = 0;
        int[] colors = net.getColorList();
        System.out.println("Estimating motif frequencies in EDD random graphs... 0%");
        double status = 0.1;
        for (i = 0; i < numRandVar; ++i) {
            gt.resetFrequencies();
            Graph randGraph = edd.sampleGraph(colors);
            randGraph.sortFastnei();
            if (this.directed) {
                randGraph.sortAdjList();
            }
            TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> mapFreqsRand = this.censusGraph(gt, randGraph, setTopologies, kocayMat, mapTopoPositions);
            if (this.dependent && !this.injective) {
                mapFreqsRand = this.aggregateDependentMultisetRand(mapFreqsRand);
            }
            for (j = 0; j < mapMotifsInfo.length; ++j) {
                boolean[][] topoAdj = setTopologies.get(j);
                if (!mapFreqsRand.containsKey(topoAdj)) continue;
                TObjectLongCustomHashMap<int[]> mapColors = mapFreqsRand.get(topoAdj);
                for (int[] colsMotif : mapMotifsInfo[j].keySet()) {
                    if (!mapColors.containsKey(colsMotif)) continue;
                    long freqRand = mapColors.get(colsMotif);
                    double[] motifInfo = mapMotifsInfo[j].get(colsMotif);
                    motifInfo[4] = motifInfo[4] + (double)freqRand;
                    if (!((double)freqRand >= motifInfo[0])) continue;
                    motifInfo[5] = motifInfo[5] + 1.0;
                }
            }
            if (!((double)i / (double)numRandVar >= status)) continue;
            System.out.println("Estimating motif frequencies in EDD random graphs... " + (int)Math.round(status * 100.0) + "%");
            status += 0.1;
        }
        System.out.println("Computing simulation-based p-value... ");
        for (j = 0; j < mapMotifsInfo.length; ++j) {
            Iterator<int[]> it = mapMotifsInfo[j].keySet().iterator();
            while (it.hasNext()) {
                int[] colsMotif = it.next();
                double[] motifInfo = mapMotifsInfo[j].get(colsMotif);
                motifInfo[4] = motifInfo[4] / (double)numRandVar;
                motifInfo[5] = motifInfo[5] / (double)numRandVar;
                if (!(motifInfo[5] > pvalThresh)) continue;
                it.remove();
            }
        }
    }
}

