/*
 * Decompiled with CFR 0.152.
 */
import gnu.trove.set.hash.TCustomHashSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public class MathUtility {
    private static int[][] matBinomCoeff = new int[][]{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 3, 3, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 4, 6, 4, 1, 0, 0, 0, 0, 0, 0}, {1, 5, 10, 10, 5, 1, 0, 0, 0, 0, 0}, {1, 6, 15, 20, 15, 6, 1, 0, 0, 0, 0}, {1, 7, 21, 35, 35, 21, 7, 1, 0, 0, 0}, {1, 8, 28, 56, 70, 56, 28, 8, 1, 0, 0}, {1, 9, 36, 84, 126, 126, 84, 36, 9, 1, 0}, {1, 10, 45, 120, 210, 252, 210, 120, 45, 10, 1}};

    public static double binomCoeff(int n, int k) {
        if (k > n) {
            return 0.0;
        }
        if (k == 0) {
            return 1.0;
        }
        if (k == 1) {
            return n;
        }
        if (n <= 10) {
            return matBinomCoeff[n][k];
        }
        if (k > n / 2) {
            k = n - k;
        }
        int m1 = n / 2;
        int m2 = n - m1;
        double res = 0.0;
        if (m1 != m2) {
            res = MathUtility.binomCoeff(2 * m1, k) + MathUtility.binomCoeff(2 * m1, k - 1);
        } else {
            int k_end;
            if (k % 2 == 1) {
                k_end = (k + 1) / 2;
            } else {
                k_end = k / 2;
                res = MathUtility.binomCoeff(m1, k_end);
                res *= res;
            }
            for (int i = 0; i < k_end; ++i) {
                res += 2.0 * (MathUtility.binomCoeff(m1, i) * MathUtility.binomCoeff(m1, k - i));
            }
        }
        return res;
    }

    public static double multinomCoeff(int n, int[] k) {
        int max = -1;
        int i_max = -1;
        for (int i = 0; i < k.length; ++i) {
            if (k[i] <= max) continue;
            i_max = i;
            max = k[i];
        }
        double res = MathUtility.factorial(n, max);
        double denom = 1.0;
        for (int i = 0; i < k.length; ++i) {
            if (i == i_max) continue;
            denom *= MathUtility.factorial(k[i], 1);
        }
        return res /= denom;
    }

    public static double factorial(int n, int k) {
        double res = n >= k + 1 ? (double)(k + 1) : 1.0;
        for (int i = k + 2; i <= n; ++i) {
            res *= (double)i;
        }
        return res;
    }

    public static boolean nextPermutation(int[] p) {
        for (int a = p.length - 2; a >= 0; --a) {
            if (p[a] >= p[a + 1]) continue;
            int b = p.length - 1;
            while (true) {
                if (p[b] > p[a]) {
                    int t = p[a];
                    p[a] = p[b];
                    p[b] = t;
                    ++a;
                    for (b = p.length - 1; a < b; ++a, --b) {
                        t = p[a];
                        p[a] = p[b];
                        p[b] = t;
                    }
                    return true;
                }
                --b;
            }
        }
        return false;
    }

    public static boolean[][] createSuperMotif(boolean[][] adjSource, boolean[][] adjDest, int s) {
        int k = adjSource.length;
        int l = 0;
        int m = 0;
        boolean[][] adjSuper = new boolean[2 * k - s][2 * k - s];
        for (l = 0; l < adjSource.length; ++l) {
            for (m = 0; m < adjSource.length; ++m) {
                adjSuper[l][m] = adjSource[l][m];
            }
        }
        for (l = 0; l < adjDest.length; ++l) {
            for (m = 0; m < adjDest.length; ++m) {
                adjSuper[l + k - s][m + k - s] = adjDest[l][m];
            }
        }
        for (l = k - s; l < k; ++l) {
            for (m = k - s; m < k; ++m) {
                adjSuper[l][m] = adjSuper[l][m] || adjSource[l][m];
            }
        }
        return adjSuper;
    }

    public static int[] createSuperColors(int[] setColors1, int[] setColors2, int s) {
        int i = 0;
        int[] superSetColors = new int[2 * setColors1.length - s];
        for (i = 0; i < setColors1.length; ++i) {
            superSetColors[i] = setColors1[i];
            superSetColors[i + setColors1.length - s] = setColors2[i];
        }
        return superSetColors;
    }

    public static HashMap<String, Integer> getSubsets(int[] set, int k) {
        HashMap<String, Integer> multiplicitySubsets = new HashMap<String, Integer>();
        int[] indexSet = new int[set.length];
        for (int i = 0; i < indexSet.length; ++i) {
            indexSet[i] = i;
        }
        HashMap setSubsets = new HashMap();
        MathUtility.getSubsets(set, indexSet, k, 0, new HashSet<Integer>(), multiplicitySubsets);
        return multiplicitySubsets;
    }

    private static void getSubsets(int[] superSet, int[] indexSet, int k, int idx, Set<Integer> current, HashMap<String, Integer> solution) {
        if (current.size() == k) {
            String sol = "";
            Iterator<Integer> it = current.iterator();
            int[] arraySol = new int[k];
            int i = 0;
            while (it.hasNext()) {
                int elem = it.next();
                arraySol[i] = superSet[elem];
                ++i;
            }
            Arrays.sort(arraySol);
            String key = "";
            for (i = 0; i < arraySol.length - 1; ++i) {
                key = key + arraySol[i] + ",";
            }
            if (solution.containsKey(key = key + arraySol[i])) {
                solution.put(key, solution.get(key) + 1);
            } else {
                solution.put(key, 1);
            }
            return;
        }
        if (idx == indexSet.length) {
            return;
        }
        int x = indexSet[idx];
        current.add(x);
        MathUtility.getSubsets(superSet, indexSet, k, idx + 1, current, solution);
        current.remove(x);
        MathUtility.getSubsets(superSet, indexSet, k, idx + 1, current, solution);
    }

    public static int sample(double[] prob, int[] probs_ids) {
        Random r = new Random();
        int indSample = 0;
        boolean found = false;
        double rand = r.nextDouble();
        for (int i = 0; i < prob.length && !found; ++i) {
            if (!((rand -= prob[probs_ids[i]]) < 0.0)) continue;
            indSample = probs_ids[i];
            found = true;
        }
        return indSample;
    }

    public static void insertionSort(double[] probs, int[] probs_ids) {
        int i = 0;
        int j = 0;
        for (j = 1; j < probs.length; ++j) {
            int key = probs_ids[j];
            for (i = j - 1; i >= 0 && probs[probs_ids[i]] > probs[key]; --i) {
                probs_ids[i + 1] = probs_ids[i];
            }
            probs_ids[i + 1] = key;
        }
    }

    public static int[] sampleMultinomial(int numSamples, double[] probs) {
        int i = 0;
        int[] probIds = new int[probs.length];
        for (i = 0; i < probIds.length; ++i) {
            probIds[i] = i;
        }
        MathUtility.insertionSort(probs, probIds);
        int[] samples = new int[numSamples];
        for (i = 0; i < numSamples; ++i) {
            samples[i] = MathUtility.sample(probs, probIds);
        }
        return samples;
    }

    public static int[] sampleMultinomial(int[] setLabels, double[][] colorProbs) {
        double[][] copyProbs = new double[colorProbs.length][];
        int i = 0;
        int j = 0;
        for (i = 0; i < colorProbs.length; ++i) {
            copyProbs[i] = new double[colorProbs[i].length];
            double sum = 0.0;
            for (j = 0; j < colorProbs[i].length; ++j) {
                copyProbs[i][j] = colorProbs[i][j];
                sum += copyProbs[i][j];
            }
            j = 0;
            while (j < copyProbs[i].length) {
                double[] dArray = copyProbs[i];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
        }
        int[][] probIds = new int[copyProbs.length][];
        for (i = 0; i < probIds.length; ++i) {
            probIds[i] = new int[copyProbs[i].length];
            for (j = 0; j < probIds[i].length; ++j) {
                probIds[i][j] = j;
            }
            MathUtility.insertionSort(copyProbs[i], probIds[i]);
        }
        int[] samples = new int[setLabels.length];
        for (i = 0; i < samples.length; ++i) {
            int col = setLabels[i] - 1;
            samples[i] = MathUtility.sample(copyProbs[col], probIds[col]);
        }
        return samples;
    }

    public static int[] setDifference(int[] A, int[] B) {
        int[] resultSet = new int[A.length - B.length];
        boolean[] checked = new boolean[B.length];
        int i = 0;
        int j = 0;
        int k = 0;
        for (i = 0; i < A.length; ++i) {
            for (j = 0; j < B.length; ++j) {
                if (checked[j] || A[i] != B[j]) continue;
                checked[j] = true;
                break;
            }
            if (j != B.length) continue;
            resultSet[k] = A[i];
            ++k;
        }
        return resultSet;
    }

    public static int[][] invertMatrix(int[][] mat) {
        double[][] identityMat = new double[mat.length][mat.length];
        int i = 0;
        int j = 0;
        int k = 0;
        for (i = 0; i < identityMat.length; ++i) {
            identityMat[i][i] = 1.0;
        }
        double[][] LU = new double[mat.length][mat.length];
        for (i = 0; i < mat.length; ++i) {
            for (j = 0; j < mat.length; ++j) {
                LU[i][j] = mat[i][j];
            }
        }
        int m = mat.length;
        int n = mat.length;
        int[] piv = new int[m];
        for (i = 0; i < m; ++i) {
            piv[i] = i;
        }
        int pivsign = 1;
        double[] LUcolj = new double[m];
        for (j = 0; j < n; ++j) {
            for (i = 0; i < m; ++i) {
                LUcolj[i] = LU[i][j];
            }
            i = 0;
            while (i < m) {
                double[] LUrowi = LU[i];
                int kmax = Math.min(i, j);
                double s = 0.0;
                for (k = 0; k < kmax; ++k) {
                    s += LUrowi[k] * LUcolj[k];
                }
                int n2 = i++;
                double d = LUcolj[n2] - s;
                LUcolj[n2] = d;
                LUrowi[j] = d;
            }
            int p = j;
            for (i = j + 1; i < m; ++i) {
                if (!(Math.abs(LUcolj[i]) > Math.abs(LUcolj[p]))) continue;
                p = i;
            }
            if (p != j) {
                for (k = 0; k < n; ++k) {
                    double t = LU[p][k];
                    LU[p][k] = LU[j][k];
                    LU[j][k] = t;
                }
                k = piv[p];
                piv[p] = piv[j];
                piv[j] = k;
                pivsign = -pivsign;
            }
            if (!(j < m & LU[j][j] != 0.0)) continue;
            for (i = j + 1; i < m; ++i) {
                double[] dArray = LU[i];
                int n3 = j;
                dArray[n3] = dArray[n3] / LU[j][j];
            }
        }
        int nx = identityMat.length;
        double[][] X = new double[mat.length][mat.length];
        for (i = 0; i < piv.length; ++i) {
            for (j = 0; j < nx; ++j) {
                X[i][j] = identityMat[piv[i]][j];
            }
        }
        for (k = 0; k < n; ++k) {
            for (i = k + 1; i < n; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] - X[k][j] * LU[i][k];
                }
            }
        }
        for (k = n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n5 = j++;
                dArray[n5] = dArray[n5] / LU[k][k];
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n6 = j;
                    dArray[n6] = dArray[n6] - X[k][j] * LU[i][k];
                }
            }
        }
        int[][] inverseMat = new int[X.length][X.length];
        for (i = 0; i < inverseMat.length; ++i) {
            for (j = 0; j < inverseMat.length; ++j) {
                inverseMat[i][j] = (int)Math.round(X[i][j]);
            }
        }
        return inverseMat;
    }

    public static Vector<boolean[][]> getNonRedPerm(boolean[][] adjMotif) {
        Vector<boolean[][]> nonRedPerm = new Vector<boolean[][]>();
        int[] currentPerm = new int[adjMotif.length];
        int i = 0;
        int j = 0;
        int k = 0;
        for (i = 0; i < currentPerm.length; ++i) {
            currentPerm[i] = i;
        }
        nonRedPerm.add(adjMotif);
        int numPerm = 1;
        while (MathUtility.nextPermutation(currentPerm)) {
            boolean[][] newAdjMotif = new boolean[adjMotif.length][adjMotif.length];
            for (i = 0; i < currentPerm.length; ++i) {
                for (j = 0; j < currentPerm.length; ++j) {
                    newAdjMotif[currentPerm[i]][currentPerm[j]] = adjMotif[i][j];
                }
            }
            for (k = 0; k < nonRedPerm.size(); ++k) {
                boolean[][] checkAdjMotif = nonRedPerm.get(k);
                boolean diff = false;
                for (i = 0; !diff && i < checkAdjMotif.length; ++i) {
                    for (j = 0; !diff && j < checkAdjMotif.length; ++j) {
                        if (newAdjMotif[i][j] == checkAdjMotif[i][j]) continue;
                        diff = true;
                    }
                }
                if (!diff) break;
            }
            if (k == nonRedPerm.size()) {
                nonRedPerm.add(newAdjMotif);
            }
            ++numPerm;
        }
        return nonRedPerm;
    }

    public static Vector<ColPermutation> getNonRedPerm(boolean[][] adjMotif, int[] setColors) {
        Vector<ColPermutation> nonRedPerm = new Vector<ColPermutation>();
        int[] currentPerm = new int[adjMotif.length];
        int i = 0;
        int j = 0;
        for (i = 0; i < currentPerm.length; ++i) {
            currentPerm[i] = i;
        }
        int[] colPerm = new int[adjMotif.length];
        for (i = 0; i < colPerm.length; ++i) {
            colPerm[i] = setColors[i];
        }
        nonRedPerm.add(new ColPermutation(adjMotif, colPerm));
        while (MathUtility.nextPermutation(currentPerm)) {
            boolean[][] newAdjMotif = new boolean[adjMotif.length][adjMotif.length];
            for (i = 0; i < currentPerm.length; ++i) {
                for (j = 0; j < currentPerm.length; ++j) {
                    newAdjMotif[currentPerm[i]][currentPerm[j]] = adjMotif[i][j];
                }
            }
            int[] newSetColors = new int[adjMotif.length];
            for (i = 0; i < currentPerm.length; ++i) {
                newSetColors[currentPerm[i]] = setColors[i];
            }
            ColPermutation newPerm = new ColPermutation(newAdjMotif, newSetColors);
            for (i = 0; i < nonRedPerm.size() && !newPerm.isEquivalentTo(nonRedPerm.get(i)); ++i) {
            }
            if (i != nonRedPerm.size()) continue;
            nonRedPerm.add(newPerm);
        }
        return nonRedPerm;
    }

    public static Vector<int[]> fillQuery(int numColors, int initSize, int[] setColors) {
        Vector<int[]> solution = new Vector<int[]>();
        MathUtility.fillQuery(numColors, 0, initSize, setColors, solution);
        return solution;
    }

    private static void fillQuery(int numColors, int lastColor, int currentSize, int[] colorSet, Vector<int[]> solution) {
        if (currentSize == colorSet.length) {
            int[] sol = new int[colorSet.length];
            int i = 0;
            for (i = 0; i < sol.length; ++i) {
                sol[i] = colorSet[i];
            }
            solution.add(sol);
        } else {
            for (int i = lastColor; i < numColors; ++i) {
                colorSet[currentSize] = i + 1;
                MathUtility.fillQuery(numColors, i, currentSize + 1, colorSet, solution);
            }
        }
    }

    public static TCustomHashSet<int[]> getColorPermutations(int[] colors) {
        TCustomHashSet<int[]> setPerms = new TCustomHashSet<int[]>(new IntArrayStrategy());
        int[] currentPerm = new int[colors.length];
        int i = 0;
        boolean j = false;
        boolean k = false;
        for (i = 0; i < currentPerm.length; ++i) {
            currentPerm[i] = i;
        }
        setPerms.add(colors);
        while (MathUtility.nextPermutation(currentPerm)) {
            int[] newPerm = new int[colors.length];
            for (i = 0; i < newPerm.length; ++i) {
                newPerm[currentPerm[i]] = colors[i];
            }
            setPerms.add(newPerm);
        }
        return setPerms;
    }
}

