/*
 * Decompiled with CFR 0.152.
 */
import gnu.trove.list.array.TIntArrayList;

public class Graph {
    private TIntArrayList[] adjList;
    private boolean directed;
    private int[] colorList;
    private TIntArrayList[] fastnei;

    public Graph(boolean directed, int numNodes, int[] colorList) {
        int i;
        this.directed = directed;
        this.adjList = new TIntArrayList[numNodes];
        for (i = 0; i < numNodes; ++i) {
            this.adjList[i] = new TIntArrayList();
        }
        if (directed) {
            this.fastnei = new TIntArrayList[numNodes];
            for (i = 0; i < numNodes; ++i) {
                this.fastnei[i] = new TIntArrayList();
            }
        } else {
            this.fastnei = this.adjList;
        }
        this.colorList = colorList;
    }

    public void addEdge(int source, int dest) {
        if (!this.adjList[source].contains(dest)) {
            this.adjList[source].add(dest);
            if (!this.directed && !this.adjList[dest].contains(source)) {
                this.adjList[dest].add(source);
            }
        }
        if (this.directed && !this.fastnei[source].contains(dest)) {
            this.fastnei[source].add(dest);
            this.fastnei[dest].add(source);
        }
    }

    public boolean isEdge(int source, int dest) {
        boolean found = false;
        int begin = 0;
        int end = this.adjList[source].size() - 1;
        while (begin <= end) {
            int median = (begin + end) / 2;
            int refVal = this.adjList[source].get(median);
            if (refVal == dest) {
                found = true;
                break;
            }
            if (refVal < dest) {
                begin = median + 1;
                continue;
            }
            end = median - 1;
        }
        return found;
    }

    public int getNumNodes() {
        return this.adjList.length;
    }

    public int getNumEdges() {
        int numEdges = 0;
        for (int i = 0; i < this.adjList.length; ++i) {
            numEdges += this.adjList[i].size();
        }
        if (!this.directed) {
            numEdges /= 2;
        }
        return numEdges;
    }

    public int getNumColors() {
        int maxColIndex = 0;
        for (int i = 0; i < this.colorList.length; ++i) {
            if (this.colorList[i] <= maxColIndex) continue;
            maxColIndex = this.colorList[i];
        }
        return maxColIndex;
    }

    public int[] getColorList() {
        return this.colorList;
    }

    public TIntArrayList[] getAdjList() {
        return this.adjList;
    }

    public TIntArrayList[] getFastnei() {
        return this.fastnei;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public double[][] getDegreeDistributions() {
        int numNodes = this.adjList.length;
        int[] degreesIn = new int[numNodes];
        int i = 0;
        int j = 0;
        for (i = 0; i < numNodes; ++i) {
            for (j = 0; j < this.adjList[i].size(); ++j) {
                int dest;
                int n = dest = this.adjList[i].get(j);
                degreesIn[n] = degreesIn[n] + 1;
            }
        }
        int maxDegOut = 0;
        int maxDegIn = 0;
        for (i = 0; i < degreesIn.length; ++i) {
            if (this.adjList[i].size() > maxDegOut) {
                maxDegOut = this.adjList[i].size();
            }
            if (degreesIn[i] <= maxDegIn) continue;
            maxDegIn = degreesIn[i];
        }
        double[][] degreeDistr = new double[][]{new double[maxDegOut + 1], new double[maxDegIn + 1]};
        for (i = 0; i < degreesIn.length; ++i) {
            double[] dArray = degreeDistr[0];
            int n = this.adjList[i].size();
            dArray[n] = dArray[n] + 1.0;
            double[] dArray2 = degreeDistr[1];
            int n2 = degreesIn[i];
            dArray2[n2] = dArray2[n2] + 1.0;
        }
        for (i = 0; i < degreeDistr.length; ++i) {
            for (j = 0; j < degreeDistr[i].length; ++j) {
                degreeDistr[i][j] = degreeDistr[i][j] / (double)numNodes;
            }
        }
        return degreeDistr;
    }

    public double[][][] getColorsDegreeDistributions() {
        int numNodes = this.adjList.length;
        int[] degreesIn = new int[numNodes];
        int i = 0;
        int j = 0;
        int k = 0;
        for (i = 0; i < numNodes; ++i) {
            for (j = 0; j < this.adjList[i].size(); ++j) {
                int dest;
                int n = dest = this.adjList[i].get(j);
                degreesIn[n] = degreesIn[n] + 1;
            }
        }
        int maxDegOut = 0;
        int maxDegIn = 0;
        for (i = 0; i < degreesIn.length; ++i) {
            if (this.adjList[i].size() > maxDegOut) {
                maxDegOut = this.adjList[i].size();
            }
            if (degreesIn[i] <= maxDegIn) continue;
            maxDegIn = degreesIn[i];
        }
        double[][][] colorsDegreeDistr = new double[2][this.getNumColors()][];
        for (i = 0; i < colorsDegreeDistr[0].length; ++i) {
            colorsDegreeDistr[0][i] = new double[maxDegOut + 1];
        }
        for (i = 0; i < colorsDegreeDistr[1].length; ++i) {
            colorsDegreeDistr[1][i] = new double[maxDegIn + 1];
        }
        for (i = 0; i < degreesIn.length; ++i) {
            double[] dArray = colorsDegreeDistr[0][this.colorList[i] - 1];
            int n = this.adjList[i].size();
            dArray[n] = dArray[n] + 1.0;
            double[] dArray2 = colorsDegreeDistr[1][this.colorList[i] - 1];
            int n2 = degreesIn[i];
            dArray2[n2] = dArray2[n2] + 1.0;
        }
        for (i = 0; i < colorsDegreeDistr.length; ++i) {
            for (j = 0; j < colorsDegreeDistr[i].length; ++j) {
                double numColNodes = 0.0;
                for (k = 0; k < colorsDegreeDistr[i][j].length; ++k) {
                    numColNodes += colorsDegreeDistr[i][j][k];
                }
                if (numColNodes == 0.0) continue;
                k = 0;
                while (k < colorsDegreeDistr[i][j].length) {
                    double[] dArray = colorsDegreeDistr[i][j];
                    int n = k++;
                    dArray[n] = dArray[n] / numColNodes;
                }
            }
        }
        return colorsDegreeDistr;
    }

    public double[] getFreqColors() {
        int numColors = this.getNumColors();
        int numNodes = this.adjList.length;
        double[] freqColors = new double[numColors];
        int i = 0;
        for (i = 0; i < this.colorList.length; ++i) {
            int n = this.colorList[i] - 1;
            freqColors[n] = freqColors[n] + 1.0;
        }
        i = 0;
        while (i < freqColors.length) {
            int n = i++;
            freqColors[n] = freqColors[n] / (double)numNodes;
        }
        return freqColors;
    }

    public void sortFastnei() {
        int i = 0;
        for (i = 0; i < this.fastnei.length; ++i) {
            this.fastnei[i].sort();
        }
    }

    public void sortAdjList() {
        int i = 0;
        for (i = 0; i < this.adjList.length; ++i) {
            this.adjList[i].sort();
        }
    }

    public String toString() {
        String str = "";
        int i = 0;
        int j = 0;
        for (i = 0; i < this.adjList.length; ++i) {
            str = str + "(" + i + "," + this.colorList[i] + ") --> ";
            for (j = 0; j < this.adjList[i].size(); ++j) {
                str = str + "(" + this.adjList[i].get(j) + "," + this.colorList[this.adjList[i].get(j)] + ") ";
            }
            str = str + "\n";
        }
        return str;
    }
}

