/*
 * Decompiled with CFR 0.152.
 */
import gnu.trove.map.custom_hash.TObjectLongCustomHashMap;
import java.util.Vector;

public class GTrieNode {
    private boolean[] in;
    private boolean[] out;
    private boolean isGraph;
    private Vector<GTrieNode> children;
    private boolean cond_ok;
    private Vector<Vector<int[]>> cond;
    private Vector<Integer> connNodes;
    private TObjectLongCustomHashMap<int[]> mapFrequencies;

    public GTrieNode(boolean isGraph) {
        this.cond_ok = true;
        this.isGraph = isGraph;
        this.in = null;
        this.out = null;
        this.children = new Vector();
        this.cond = new Vector();
    }

    public GTrieNode(boolean[] in, boolean[] out, boolean isGraph) {
        this.in = in;
        this.out = out;
        this.isGraph = isGraph;
        this.children = new Vector();
        this.cond_ok = false;
        this.cond = new Vector();
        int i = 0;
        this.connNodes = new Vector();
        for (i = 0; i < out.length; ++i) {
            if (!out[i] && !in[i]) continue;
            this.connNodes.add(i);
        }
        this.mapFrequencies = new TObjectLongCustomHashMap<int[]>(new IntArrayStrategy());
    }

    public boolean[] getInNeighbors() {
        return this.in;
    }

    public boolean[] getOutNeighbors() {
        return this.out;
    }

    public boolean isLeaf() {
        return this.isGraph;
    }

    public Vector<GTrieNode> getChildren() {
        return this.children;
    }

    public void insertChild(GTrieNode gtn) {
        this.children.add(gtn);
    }

    public void setIsGraph(boolean val) {
        this.isGraph = val;
    }

    public void clearConditions() {
        this.cond.clear();
    }

    public boolean getCondOk() {
        return this.cond_ok;
    }

    public void setCondOk(boolean val) {
        this.cond_ok = val;
    }

    public Vector<Vector<int[]>> getSymmCond() {
        return this.cond;
    }

    public Vector<Integer> getConnNodes() {
        return this.connNodes;
    }

    public TObjectLongCustomHashMap<int[]> getMapFrequencies() {
        return this.mapFrequencies;
    }

    public void incFrequency(int[] setColors) {
        boolean ans = this.mapFrequencies.increment(setColors);
        if (!ans) {
            this.mapFrequencies.put(setColors, 1L);
        }
    }

    public void resetMapFrequencies() {
        this.mapFrequencies.clear();
    }
}

