/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class EDDInjective
extends EDDModel {
    public EDDInjective(int numNodes, boolean directed, double[] freqColors, boolean dependent, double[] degreeDistrOut, double[] degreeDistrIn, double[][] colorsDistrOut, double[][] colorsDistrIn) {
        super(numNodes, directed, freqColors, dependent, degreeDistrOut, degreeDistrIn, colorsDistrOut, colorsDistrIn);
    }

    public double computeOccProb(boolean[][] adjMotif, int[] setColors) {
        int numEdgesMotif = 0;
        if (this.directed) {
            int[] outDegrees = new int[adjMotif.length];
            int[] inDegrees = new int[adjMotif.length];
            int i = 0;
            int j = 0;
            for (i = 0; i < adjMotif.length; ++i) {
                for (j = 0; j < adjMotif.length; ++j) {
                    if (!adjMotif[i][j]) continue;
                    ++numEdgesMotif;
                    int n = i;
                    outDegrees[n] = outDegrees[n] + 1;
                    int n2 = j;
                    inDegrees[n2] = inDegrees[n2] + 1;
                }
            }
            double probTopology = this.gammaPowers[numEdgesMotif];
            if (this.dependent) {
                for (i = 0; i < adjMotif.length; ++i) {
                    probTopology *= this.freqColors[setColors[i] - 1] * this.momentsColorsOut[setColors[i] - 1][outDegrees[i]] * this.momentsColorsIn[setColors[i] - 1][inDegrees[i]];
                }
            } else {
                for (i = 0; i < adjMotif.length; ++i) {
                    probTopology *= this.freqColors[setColors[i] - 1] * this.momentsOut[outDegrees[i]] * this.momentsIn[inDegrees[i]];
                }
            }
            return probTopology;
        }
        int[] outDegrees = new int[adjMotif.length];
        int i = 0;
        int j = 0;
        for (i = 0; i < adjMotif.length; ++i) {
            for (j = i + 1; j < adjMotif.length; ++j) {
                if (!adjMotif[i][j]) continue;
                ++numEdgesMotif;
                int n = i;
                outDegrees[n] = outDegrees[n] + 1;
                int n3 = j;
                outDegrees[n3] = outDegrees[n3] + 1;
            }
        }
        double probTopology = this.gammaPowers[numEdgesMotif];
        if (this.dependent) {
            for (i = 0; i < adjMotif.length; ++i) {
                probTopology *= this.freqColors[setColors[i] - 1] * this.momentsColorsOut[setColors[i] - 1][outDegrees[i]];
            }
        } else {
            for (i = 0; i < adjMotif.length; ++i) {
                probTopology *= this.freqColors[setColors[i] - 1] * this.momentsOut[outDegrees[i]];
            }
        }
        return probTopology;
    }

    @Override
    public double computeMean(Vector<ColPermutation> nrPerm) {
        boolean[][] adjMotif = nrPerm.get(0).getAdjTopology();
        int[] setColors = nrPerm.get(0).getColors();
        int roColPerms = nrPerm.size();
        double binomCoeff = MathUtility.binomCoeff(this.numNodes, setColors.length);
        double probOcc = this.computeOccProb(adjMotif, setColors);
        double mean = binomCoeff * (double)roColPerms * probOcc;
        return mean;
    }

    @Override
    public double computeVariance(Vector<ColPermutation> nrPerm, double mean, double[] coeffOverlap) {
        int i = 0;
        int j = 0;
        int l = 0;
        boolean[][] adjMotif = nrPerm.get(0).getAdjTopology();
        int[] setColors = nrPerm.get(0).getColors();
        int k = adjMotif.length;
        int numberColPerms = nrPerm.size();
        double varPerm = (double)numberColPerms * this.computeOccProb(adjMotif, setColors);
        double moment2 = coeffOverlap[0] * varPerm * varPerm;
        double overlappingSum = 0.0;
        for (int s = 1; s <= k; ++s) {
            double probSuperMotif = 0.0;
            for (i = 0; i < nrPerm.size(); ++i) {
                boolean[][] adjSource = nrPerm.get(i).getAdjTopology();
                int[] setColorsSource = nrPerm.get(i).getColors();
                for (j = 0; j < nrPerm.size(); ++j) {
                    boolean[][] adjDest = nrPerm.get(j).getAdjTopology();
                    int[] setColorsDest = nrPerm.get(j).getColors();
                    boolean diffColorsOverlap = false;
                    for (l = 0; l < s; ++l) {
                        if (setColorsSource[k - s + l] == setColorsDest[l]) continue;
                        diffColorsOverlap = true;
                        break;
                    }
                    if (diffColorsOverlap) continue;
                    boolean[][] adjSuper = MathUtility.createSuperMotif(adjSource, adjDest, s);
                    int[] superColors = MathUtility.createSuperColors(setColorsSource, setColorsDest, s);
                    probSuperMotif += this.computeOccProb(adjSuper, superColors);
                }
            }
            overlappingSum += coeffOverlap[s] * probSuperMotif;
        }
        double variance = (moment2 += overlappingSum) - mean * mean;
        return variance;
    }

    private double computeCovariance(Vector<ColPermutation> nrPerm1, Vector<ColPermutation> nrPerm2, double[] coeffOverlap) {
        boolean[][] adjMotif1 = nrPerm1.get(0).getAdjTopology();
        int[] setColors = nrPerm1.get(0).getColors();
        double probOcc1 = this.computeOccProb(adjMotif1, setColors);
        boolean[][] adjMotif2 = nrPerm2.get(0).getAdjTopology();
        double probOcc2 = this.computeOccProb(adjMotif2, setColors);
        double firstTermCov = coeffOverlap[0] * (double)nrPerm1.size() * probOcc1 * (double)nrPerm2.size() * probOcc2;
        int s = 0;
        int i = 0;
        int j = 0;
        int l = 0;
        double secondTermCov = 0.0;
        for (s = 1; s < coeffOverlap.length; ++s) {
            double probSuperMotif = 0.0;
            for (i = 0; i < nrPerm1.size(); ++i) {
                boolean[][] adjSource = nrPerm1.get(i).getAdjTopology();
                int[] setColorsSource = nrPerm1.get(i).getColors();
                for (j = 0; j < nrPerm2.size(); ++j) {
                    boolean[][] adjDest = nrPerm2.get(j).getAdjTopology();
                    int[] setColorsDest = nrPerm2.get(j).getColors();
                    boolean diffColorsOverlap = false;
                    for (l = 0; l < s; ++l) {
                        if (setColorsSource[adjSource.length - s + l] == setColorsDest[l]) continue;
                        diffColorsOverlap = true;
                        break;
                    }
                    if (diffColorsOverlap) continue;
                    boolean[][] adjSuper = MathUtility.createSuperMotif(adjSource, adjDest, s);
                    int[] superColors = MathUtility.createSuperColors(setColorsSource, setColorsDest, s);
                    probSuperMotif += this.computeOccProb(adjSuper, superColors);
                }
            }
            secondTermCov += coeffOverlap[s] * probSuperMotif;
        }
        double thirdTermCov = this.computeMean(nrPerm1) * this.computeMean(nrPerm2);
        double covariance = firstTermCov + secondTermCov - thirdTermCov;
        return covariance;
    }

    @Override
    public double[] computeSetMeans(Vector<ColPermutation>[] nrPerm) {
        double[] setMeans = new double[nrPerm.length];
        int i = 0;
        for (i = 0; i < setMeans.length; ++i) {
            setMeans[i] = this.computeMean(nrPerm[i]);
        }
        return setMeans;
    }

    @Override
    public double[] computeSetVariances(Vector<ColPermutation>[] nrPerm, double[] setMeans, double[] coeffOverlap) {
        double[] setVariances = new double[nrPerm.length];
        int i = 0;
        for (i = 0; i < setVariances.length; ++i) {
            setVariances[i] = this.computeVariance(nrPerm[i], setMeans[i], coeffOverlap);
        }
        return setVariances;
    }

    @Override
    public double[] computeSetCovariances(Vector<ColPermutation>[] nrPerm, double[] coeffOverlap) {
        double[] setCovariances = new double[nrPerm.length * (nrPerm.length - 1) / 2];
        int i = 0;
        int j = 0;
        int l = 0;
        for (i = 0; i < nrPerm.length; ++i) {
            for (j = i + 1; j < nrPerm.length; ++j) {
                setCovariances[l] = this.computeCovariance(nrPerm[i], nrPerm[j], coeffOverlap);
                ++l;
            }
        }
        return setCovariances;
    }

    @Override
    public double computeMeanInducedPreproc(int[] kocayInv, double[] setMeans) {
        int i = 0;
        double meanInduced = 0.0;
        for (i = 0; i < kocayInv.length; ++i) {
            if (kocayInv[i] == 0) continue;
            meanInduced += (double)kocayInv[i] * setMeans[i];
        }
        return meanInduced;
    }

    @Override
    public double computeVarianceInducedPreproc(int[] kocayInv, double[] setVariances, double[] setCovariances, double[] coeffOverlap) {
        int i = 0;
        int j = 0;
        double termVar = 0.0;
        for (i = 0; i < kocayInv.length; ++i) {
            if (kocayInv[i] == 0) continue;
            termVar += (double)(kocayInv[i] * kocayInv[i]) * setVariances[i];
        }
        double termCovar = 0.0;
        int l = 0;
        for (i = 0; i < kocayInv.length; ++i) {
            for (j = i + 1; j < kocayInv.length; ++j) {
                if (kocayInv[i] != 0 && kocayInv[j] != 0) {
                    termCovar += (double)(kocayInv[i] * kocayInv[j]) * setCovariances[l];
                }
                ++l;
            }
        }
        double varianceInduced = termVar + 2.0 * termCovar;
        return varianceInduced;
    }
}

