/*
 * Decompiled with CFR 0.152.
 */
import gnu.trove.map.custom_hash.TObjectLongCustomHashMap;
import gnu.trove.map.hash.TCustomHashMap;
import java.util.Vector;
import org.jfree.chart.JFreeChart;

public class AnalyticalRepro {
    public static void main(String[] args) throws Exception {
        String netFile = null;
        int motifSize = 3;
        String colConstrString = null;
        String topoConstrFile = null;
        int numRandVar = 1000;
        boolean injective = true;
        boolean induced = true;
        boolean dependent = true;
        int minFreq = 1;
        double pvalAnalThresh = 1.0;
        double pvalSimulThresh = 1.0;
        String outputFile = "results.txt";
        String outputFilePlot = "prPlot.pdf";
        int i = 0;
        boolean j = false;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-n")) {
                netFile = args[++i];
                continue;
            }
            if (args[i].equals("-m")) {
                motifSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-indep")) {
                dependent = false;
                continue;
            }
            if (args[i].equals("-nonind")) {
                induced = false;
                continue;
            }
            if (args[i].equals("-multi")) {
                injective = false;
                continue;
            }
            if (args[i].equals("-nr")) {
                numRandVar = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-cc")) {
                colConstrString = args[++i];
                continue;
            }
            if (args[i].equals("-tc")) {
                topoConstrFile = args[++i];
                continue;
            }
            if (args[i].equals("-ps")) {
                pvalSimulThresh = Double.parseDouble(args[++i]);
                continue;
            }
            if (args[i].equals("-pa")) {
                pvalAnalThresh = Double.parseDouble(args[++i]);
                continue;
            }
            if (args[i].equals("-f")) {
                minFreq = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-or")) {
                outputFile = args[++i];
                continue;
            }
            if (args[i].equals("-op")) {
                outputFilePlot = args[++i];
                continue;
            }
            System.out.println("Error! Unrecognizable command '" + args[i] + "'");
            AnalyticalRepro.printHelp();
            System.exit(1);
        }
        if (netFile == null) {
            System.out.println("Error! No input network has been specified!\n");
            AnalyticalRepro.printHelp();
            System.exit(1);
        }
        System.out.print("Searching for colored ");
        if (induced) {
            System.out.print("induced ");
        } else {
            System.out.print("non-induced ");
        }
        if (injective) {
            System.out.print("injective ");
        } else {
            System.out.print("multiset ");
        }
        System.out.print("motifs of size " + motifSize + " with color-topology ");
        if (dependent) {
            System.out.print("dependence...");
        } else {
            System.out.print("independence...");
        }
        double startCommon = System.currentTimeMillis();
        System.out.println("\nReading graph file...");
        FileManager fm = new FileManager();
        Graph net = fm.readGraph(netFile);
        boolean directed = net.isDirected();
        int[] colorConstr = new int[motifSize];
        if (colConstrString != null) {
            String[] split = colConstrString.split(",");
            int numConstr = Math.min(motifSize, split.length);
            for (i = 0; i < numConstr; ++i) {
                colorConstr[i] = Integer.parseInt(split[i]);
            }
        }
        System.out.println("Building Kocay matrix...");
        MotifManager mm = new MotifManager(motifSize, directed, colorConstr, injective, induced, dependent);
        TCustomHashMap<boolean[][], Integer> mapTopoPositions = fm.buildCompleteTopoSet(motifSize, directed);
        int[][] kocayMat = mm.buildKocayMatrix(mapTopoPositions, motifSize, directed);
        System.out.println("Generating motif topologies according to user constraints...");
        Vector<boolean[][]> setTopologies = fm.readMotifs(topoConstrFile, mapTopoPositions);
        System.out.println("Building GTrie data structure...");
        GTrie gt = induced ? new GTrie(setTopologies) : new GTrie(mapTopoPositions);
        System.out.println("Estimating motif frequencies in input network...");
        TCustomHashMap<boolean[][], TObjectLongCustomHashMap<int[]>> mapFreqs = mm.censusGraph(gt, net, setTopologies, kocayMat, mapTopoPositions);
        TCustomHashMap[] mapMotifsInfo = new TCustomHashMap[setTopologies.size()];
        int numMotifs = mm.getSetRecurrentMotifs(mapMotifsInfo, setTopologies, mapFreqs, minFreq, 6);
        double endCommon = System.currentTimeMillis();
        double totalTimeCommon = (endCommon - startCommon) / 1000.0;
        double startAnal = System.currentTimeMillis();
        EDDModel edd = mm.setupEDDModel(net);
        mapMotifsInfo = mm.computeAnalyticalPValues(edd, net, mapMotifsInfo, setTopologies, mapTopoPositions, kocayMat, numMotifs, pvalAnalThresh);
        double endAnal = System.currentTimeMillis();
        double totalTimeAnal = (endAnal - startAnal) / 1000.0;
        double startSimul = System.currentTimeMillis();
        mm.computeSimulPValues(edd, gt, net, numRandVar, setTopologies, kocayMat, mapTopoPositions, mapMotifsInfo, pvalSimulThresh);
        double endSimul = System.currentTimeMillis();
        double totalTimeSimul = (endSimul - startSimul) / 1000.0;
        fm.writeMotifResults(mapMotifsInfo, setTopologies, outputFile, true);
        System.out.println("Making precision-recall plot... ");
        PlotManager pm = new PlotManager(netFile, motifSize, induced, injective, dependent);
        JFreeChart chart = pm.createPRPlot(mapMotifsInfo);
        fm.savePlotToPDFFile(chart, outputFilePlot);
        System.out.println("Done! Plot saved in " + outputFilePlot);
        System.out.println("Running time of analytical model-based algorithm: " + (totalTimeAnal += totalTimeCommon) + " secs");
        System.out.println("Running time of simulation model-based algorithm: " + (totalTimeSimul += totalTimeCommon) + " secs");
    }

    public static void printHelp() {
        String help = "Usage: java -jar AnalyticalRepro.jar -n <networkFile> [-m <motifSize> -indep -multi -nonind -nr <numRandomVariants> -cc <colorConstraints> -tc <topoConstraints> -ps <pvalSimulThresh> -pa <pvalAnalThresh> -f <minFrequency> -or <resultsFile> -op <plotFile>]\n\n";
        help = help + "REQUIRED PARAMETERS:\n";
        help = help + "-n\tInput network file\n\n";
        help = help + "OPTIONAL PARAMETERS:\n";
        help = help + "-m\tMotif size (default=3)\n";
        help = help + "-indep\tUse EDD with color-degree independency as random model (default=color-topology dependent EDD model)\n";
        help = help + "-multi\tSearch for multiset topological colored motifs (default=injective topological colored motifs)\n";
        help = help + "-nonind\tSearch for non-induced motifs (default=induced motifs)\n";
        help = help + "-nr\tNumber of random variants used for computing simulation-based p-value (default=1000)\n";
        help = help + "-cc\tString of color constraints (e.g. 1,1,2 means that motif must contain at least 2 nodes of color '1' and 1 node of color '2') (default=no color constraints)\n";
        help = help + "-tc\tText file with adjacency strings of topologies that motifs must have (default=no topology constraints)\n";
        help = help + "-ps\tReturn only motifs with simulation-based p-value below this threshold (default=1.0)\n";
        help = help + "-pa\tReturn only motifs with analytical-based p-value below this threshold (default=1.0)\n";
        help = help + "-f\tReturn only motifs whose frequency in the input network is greater than or equals to this value (default=1)\n";
        help = help + "-or\tOutput file where results will be saved (default=results.txt)\n";
        help = help + "-op\tOutput file where Precision-Recall plot will be saved (default=prPlot.pdf)\n";
        System.out.println(help);
    }
}

